/*
 * Decompiled with CFR 0.152.
 */
package org.grails.config;

import grails.util.Environment;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

public class EnvironmentAwarePropertySource
extends EnumerablePropertySource<PropertySources> {
    protected List<String> propertyNames;

    EnvironmentAwarePropertySource(PropertySources source) {
        super("grails.environment", source);
    }

    @Override
    public String[] getPropertyNames() {
        this.initialize();
        return this.propertyNames.toArray(new String[this.propertyNames.size()]);
    }

    @Override
    public Object getProperty(String name) {
        this.initialize();
        if (!this.propertyNames.contains(name)) {
            return null;
        }
        Environment env = Environment.getCurrent();
        String key = "environments." + env.getName() + "." + name;
        for (PropertySource propertySource : (PropertySources)this.source) {
            Object value;
            if (propertySource == this || (value = propertySource.getProperty(key)) == null) continue;
            return value;
        }
        return null;
    }

    private void initialize() {
        if (this.propertyNames == null) {
            this.propertyNames = new ArrayList<String>();
            Environment env = Environment.getCurrent();
            String key = "environments." + env.getName();
            for (PropertySource propertySource : (PropertySources)this.source) {
                if (propertySource == this || propertySource.getName().contains("plugin") || !(propertySource instanceof EnumerablePropertySource)) continue;
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                    if (!propertyName.startsWith(key) || propertyName.length() <= key.length()) continue;
                    this.propertyNames.add(propertyName.substring(key.length() + 1));
                }
            }
        }
    }
}

