/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import jakarta.inject.Singleton;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.database.MongoFeature;
import org.grails.forge.feature.database.TestContainers;

@Singleton
public class MongoSync
extends MongoFeature {
    public MongoSync(TestContainers testContainers) {
        super(testContainers);
    }

    @Override
    public String getName() {
        return "mongo-sync";
    }

    @Override
    public String getTitle() {
        return "MongoDB Synchronous Driver";
    }

    @Override
    public String getDescription() {
        return "Add support for the MongoDB Synchronous Driver.";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        ApplicationConfiguration config = generatorContext.getConfiguration();
        config.put("grails.mongodb.url", "mongodb://${MONGO_HOST:localhost}:${MONGO_PORT:27017}/foo");
        generatorContext.addDependency(Dependency.builder().groupId("org.mongodb").artifactId("mongodb-driver-sync").implementation());
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public String getCategory() {
        return "Database";
    }

    @Override
    public String getDocumentation() {
        return "https://www.mongodb.com/docs/drivers/java/sync/current/";
    }

    @Override
    public String getThirdPartyDocumentation() {
        return "https://www.mongodb.com/docs/";
    }
}

