/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.SerializerFactory;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public abstract class StateDescriptor<S extends State, T>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StateDescriptor.class);
    private static final long serialVersionUID = 1L;
    protected final String name;
    private final AtomicReference<TypeSerializer<T>> serializerAtomicReference = new AtomicReference();
    @Nullable
    private TypeInformation<T> typeInfo;
    @Nullable
    private String queryableStateName;
    @Nonnull
    private StateTtlConfig ttlConfig = StateTtlConfig.DISABLED;
    @Nullable
    @Deprecated
    protected transient T defaultValue;

    protected StateDescriptor(String name, TypeSerializer<T> serializer, @Nullable T defaultValue) {
        this.name = Preconditions.checkNotNull(name, "name must not be null");
        this.serializerAtomicReference.set(Preconditions.checkNotNull(serializer, "serializer must not be null"));
        this.defaultValue = defaultValue;
    }

    protected StateDescriptor(String name, TypeInformation<T> typeInfo, @Nullable T defaultValue) {
        this.name = Preconditions.checkNotNull(name, "name must not be null");
        this.typeInfo = Preconditions.checkNotNull(typeInfo, "type information must not be null");
        this.defaultValue = defaultValue;
    }

    protected StateDescriptor(String name, Class<T> type, @Nullable T defaultValue) {
        this.name = Preconditions.checkNotNull(name, "name must not be null");
        Preconditions.checkNotNull(type, "type class must not be null");
        try {
            this.typeInfo = TypeExtractor.createTypeInfo(type);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the type information for '" + type.getName() + "'. The most common reason is failure to infer the generic type information, due to Java's type erasure. In that case, please pass a 'TypeHint' instead of a class to describe the type. For example, to describe 'Tuple2<String, String>' as a generic type, use 'new PravegaDeserializationSchema<>(new TypeHint<Tuple2<String, String>>(){}, serializer);'", e);
        }
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        if (this.defaultValue != null) {
            TypeSerializer<T> serializer = this.serializerAtomicReference.get();
            if (serializer != null) {
                return serializer.copy(this.defaultValue);
            }
            throw new IllegalStateException("Serializer not yet initialized.");
        }
        return null;
    }

    public TypeSerializer<T> getSerializer() {
        TypeSerializer<T> serializer = this.serializerAtomicReference.get();
        if (serializer != null) {
            return serializer.duplicate();
        }
        throw new IllegalStateException("Serializer not yet initialized.");
    }

    @VisibleForTesting
    final TypeSerializer<T> getOriginalSerializer() {
        TypeSerializer<T> serializer = this.serializerAtomicReference.get();
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalStateException("Serializer not yet initialized.");
    }

    @Deprecated
    public void setQueryable(String queryableStateName) {
        Preconditions.checkArgument(this.ttlConfig.getUpdateType() == StateTtlConfig.UpdateType.Disabled, "Queryable state is currently not supported with TTL");
        if (this.queryableStateName != null) {
            throw new IllegalStateException("Queryable state name already set");
        }
        this.queryableStateName = Preconditions.checkNotNull(queryableStateName, "Registration name");
    }

    @Nullable
    @Deprecated
    public String getQueryableStateName() {
        return this.queryableStateName;
    }

    @Deprecated
    public boolean isQueryable() {
        return this.queryableStateName != null;
    }

    public void enableTimeToLive(StateTtlConfig ttlConfig) {
        Preconditions.checkNotNull(ttlConfig);
        if (ttlConfig.isEnabled()) {
            Preconditions.checkArgument(this.queryableStateName == null, "Queryable state is currently not supported with TTL");
        }
        this.ttlConfig = ttlConfig;
    }

    @Nonnull
    @Internal
    public StateTtlConfig getTtlConfig() {
        return this.ttlConfig;
    }

    public boolean isSerializerInitialized() {
        return this.serializerAtomicReference.get() != null;
    }

    public void initializeSerializerUnlessSet(final ExecutionConfig executionConfig) {
        this.initializeSerializerUnlessSet(new SerializerFactory(){

            @Override
            public <T> TypeSerializer<T> createSerializer(TypeInformation<T> typeInformation) {
                return typeInformation.createSerializer(executionConfig == null ? null : executionConfig.getSerializerConfig());
            }
        });
    }

    @Internal
    public void initializeSerializerUnlessSet(SerializerFactory serializerFactory) {
        if (this.serializerAtomicReference.get() == null) {
            Preconditions.checkState(this.typeInfo != null, "no serializer and no type info");
            TypeSerializer<T> serializer = serializerFactory.createSerializer(this.typeInfo);
            if (!this.serializerAtomicReference.compareAndSet(null, serializer)) {
                LOG.debug("Someone else beat us at initializing the serializer.");
            }
        }
    }

    public final int hashCode() {
        return this.name.hashCode() + 31 * this.getClass().hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            StateDescriptor that = (StateDescriptor)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", defaultValue=" + this.defaultValue + ", serializer=" + this.serializerAtomicReference.get() + (this.isQueryable() ? ", queryableStateName=" + this.queryableStateName + "" : "") + '}';
    }

    public abstract Type getType();

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.defaultValue == null) {
            out.writeBoolean(false);
        } else {
            byte[] serializedDefaultValue;
            TypeSerializer<T> serializer = this.serializerAtomicReference.get();
            Preconditions.checkNotNull(serializer, "Serializer not initialized.");
            out.writeBoolean(true);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper(baos);){
                TypeSerializer<T> duplicateSerializer = serializer.duplicate();
                duplicateSerializer.serialize(this.defaultValue, outView);
                outView.flush();
                serializedDefaultValue = baos.toByteArray();
            }
            catch (Exception e) {
                throw new IOException("Unable to serialize default value of type " + this.defaultValue.getClass().getSimpleName() + ".", e);
            }
            out.writeInt(serializedDefaultValue.length);
            out.write(serializedDefaultValue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block27: {
            in.defaultReadObject();
            boolean hasDefaultValue = in.readBoolean();
            if (hasDefaultValue) {
                TypeSerializer<T> serializer = this.serializerAtomicReference.get();
                Preconditions.checkNotNull(serializer, "Serializer not initialized.");
                int size = in.readInt();
                byte[] buffer = new byte[size];
                in.readFully(buffer);
                try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                     DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper(bais);){
                    this.defaultValue = serializer.deserialize(inView);
                    break block27;
                }
                catch (Exception e) {
                    throw new IOException("Unable to deserialize default value.", e);
                }
            }
            this.defaultValue = null;
        }
    }

    public static enum Type {
        UNKNOWN,
        VALUE,
        LIST,
        REDUCING,
        FOLDING,
        AGGREGATING,
        MAP;

    }
}

