/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.variables.resolver;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.resolver.IVariableResolver;
import org.apache.hop.core.variables.resolver.VariableResolverPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
@VariableResolverPlugin(id="AzureKeyVault", name="Azure Key Vault Variable Resolver", description="Resolves variables from Azure Key Vault secrets", documentationUrl="/metadata-types/variable-resolver/azure-key-vault-variable-resolver.html")
public class AzureKeyVaultVariableResolver
implements IVariableResolver {
    private static final LogChannel log = new LogChannel((Object)"AzureKeyVaultVariableResolver");
    private transient SecretClient secretClient;
    private transient boolean initialized = false;
    private transient boolean failedInitialization = false;
    @GuiWidgetElement(id="azureKeyVaultUri", parentId="VariableResolver-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::AzureKeyVaultVariableResolver.AzureKeyVaultUri.Label", toolTip="i18n::AzureKeyVaultVariableResolver.AzureKeyVaultUri.Tooltip")
    @HopMetadataProperty
    private String azureKeyVaultUri;
    @GuiWidgetElement(id="azureTenantId", parentId="VariableResolver-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::AzureKeyVaultVariableResolver.AzureTenantId.Label", toolTip="i18n::AzureKeyVaultVariableResolver.AzureTenantId.Tooltip")
    @HopMetadataProperty
    private String azureTenantId;
    @GuiWidgetElement(id="azureClientId", parentId="VariableResolver-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::AzureKeyVaultVariableResolver.AzureClientId.Label", toolTip="i18n::AzureKeyVaultVariableResolver.AzureClientId.Tooltip")
    @HopMetadataProperty
    private String azureClientId;
    @GuiWidgetElement(id="azureClientSecret", parentId="VariableResolver-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::AzureKeyVaultVariableResolver.AzureClientSecret.Label", toolTip="i18n::AzureKeyVaultVariableResolver.AzureClientSecret.Tooltip", password=true)
    @HopMetadataProperty(password=true)
    private String azureClientSecret;

    public synchronized void init() {
    }

    private synchronized void init(IVariables variables) {
        try {
            if (this.initialized || this.failedInitialization) {
                log.logDetailed("Azure Key Vault Variable Resolver already initialized or failed. initialized=" + this.initialized + ", failedInitialization=" + this.failedInitialization);
                return;
            }
            log.logDetailed("=== AZURE KEY VAULT VARIABLE RESOLVER: Starting initialization ===");
            String resolvedVaultUri = variables.resolve(this.getAzureKeyVaultUri());
            String resolvedTenantId = variables.resolve(this.getAzureTenantId());
            String resolvedClientId = variables.resolve(this.getAzureClientId());
            String resolvedClientSecret = variables.resolve(this.getAzureClientSecret());
            log.logDetailed("Azure Key Vault URI: " + (StringUtils.isEmpty((String)resolvedVaultUri) ? "EMPTY" : resolvedVaultUri));
            log.logDetailed("Azure Tenant ID: " + (StringUtils.isEmpty((String)resolvedTenantId) ? "EMPTY" : resolvedTenantId));
            log.logDetailed("Azure Client ID: " + (StringUtils.isEmpty((String)resolvedClientId) ? "EMPTY" : resolvedClientId));
            log.logDetailed("Azure Client Secret: " + (StringUtils.isEmpty((String)resolvedClientSecret) ? "EMPTY" : "***SET***"));
            if (StringUtils.isEmpty((String)resolvedVaultUri) || StringUtils.isEmpty((String)resolvedTenantId) || StringUtils.isEmpty((String)resolvedClientId) || StringUtils.isEmpty((String)resolvedClientSecret)) {
                throw new HopException("Missing one or more required Azure Key Vault configuration values in the Variable Resolver metadata.");
            }
            String decryptedClientSecret = Encr.decryptPasswordOptionallyEncrypted((String)resolvedClientSecret);
            ClientSecretCredential credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(resolvedTenantId)).clientId(resolvedClientId)).clientSecret(decryptedClientSecret).build();
            this.secretClient = new SecretClientBuilder().vaultUrl(resolvedVaultUri).credential((TokenCredential)credential).buildClient();
            log.logDetailed("Successfully initialized Azure Key Vault client for: " + resolvedVaultUri);
            this.initialized = true;
        }
        catch (Exception e) {
            log.logError("Failed to initialize Azure Key Vault client. This resolver will be disabled.", (Throwable)e);
            this.failedInitialization = true;
        }
    }

    public String resolve(String secretId, IVariables variables) throws HopException {
        log.logDetailed("=== AZURE KEY VAULT VARIABLE RESOLVER: resolve() called with secretId='" + secretId + "' ===");
        this.init(variables);
        if (this.failedInitialization || this.secretClient == null) {
            log.logError("Cannot resolve secret - initialization failed or secretClient is null. failedInitialization=" + this.failedInitialization + ", secretClient=" + (this.secretClient == null ? "null" : "present"));
            return null;
        }
        if (StringUtils.isEmpty((String)secretId)) {
            log.logError("Cannot resolve secret - secretId is empty");
            return null;
        }
        try {
            String resolvedVaultUri = variables.resolve(this.getAzureKeyVaultUri());
            log.logDetailed("Attempting to resolve secret '" + secretId + "' from Azure Key Vault: " + resolvedVaultUri);
            KeyVaultSecret secret = this.secretClient.getSecret(secretId);
            String value = secret.getValue();
            log.logDetailed("Successfully resolved secret '" + secretId + "' (value length: " + (value != null ? value.length() : 0) + ")");
            return value;
        }
        catch (ResourceNotFoundException e) {
            log.logError("Secret not found in Azure Key Vault: '" + secretId + "'", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.logError("An error occurred while fetching secret '" + secretId + "' from Azure Key Vault", (Throwable)e);
            return null;
        }
    }

    public void setPluginId() {
    }

    public String getPluginId() {
        return "AzureKeyVault";
    }

    public void setPluginName(String pluginName) {
    }

    public String getPluginName() {
        return "Azure Key Vault Variable Resolver";
    }

    @Generated
    public SecretClient getSecretClient() {
        return this.secretClient;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public boolean isFailedInitialization() {
        return this.failedInitialization;
    }

    @Generated
    public String getAzureKeyVaultUri() {
        return this.azureKeyVaultUri;
    }

    @Generated
    public String getAzureTenantId() {
        return this.azureTenantId;
    }

    @Generated
    public String getAzureClientId() {
        return this.azureClientId;
    }

    @Generated
    public String getAzureClientSecret() {
        return this.azureClientSecret;
    }

    @Generated
    public void setSecretClient(SecretClient secretClient) {
        this.secretClient = secretClient;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Generated
    public void setFailedInitialization(boolean failedInitialization) {
        this.failedInitialization = failedInitialization;
    }

    @Generated
    public void setAzureKeyVaultUri(String azureKeyVaultUri) {
        this.azureKeyVaultUri = azureKeyVaultUri;
    }

    @Generated
    public void setAzureTenantId(String azureTenantId) {
        this.azureTenantId = azureTenantId;
    }

    @Generated
    public void setAzureClientId(String azureClientId) {
        this.azureClientId = azureClientId;
    }

    @Generated
    public void setAzureClientSecret(String azureClientSecret) {
        this.azureClientSecret = azureClientSecret;
    }
}

