/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Iterator;
import java.util.Queue;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchQueryCall;
import org.apache.bifromq.basekv.client.scheduler.QueryCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.InboxStateReply;
import org.apache.bifromq.inbox.rpc.proto.InboxStateRequest;
import org.apache.bifromq.inbox.storage.proto.BatchFetchInboxStateReply;
import org.apache.bifromq.inbox.storage.proto.BatchFetchInboxStateRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceROCoProcInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchInboxStateCall
extends BatchQueryCall<InboxStateRequest, InboxStateReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchInboxStateCall.class);

    protected BatchInboxStateCall(IQueryPipeline pipeline, QueryCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected ROCoProcInput makeBatch(Iterator<InboxStateRequest> reqIterator) {
        BatchFetchInboxStateRequest.Builder reqBuilder = BatchFetchInboxStateRequest.newBuilder();
        reqIterator.forEachRemaining(request -> reqBuilder.addParams(BatchFetchInboxStateRequest.Params.newBuilder().setTenantId(request.getTenantId()).setInboxId(request.getInboxId()).setNow(request.getNow()).build()));
        long reqId = System.nanoTime();
        return ROCoProcInput.newBuilder().setInboxService(InboxServiceROCoProcInput.newBuilder().setReqId(reqId).setFetchInboxState(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<InboxStateRequest, InboxStateReply, QueryCallBatcherKey>> batchedTasks, ROCoProcOutput output) {
        ICallTask<InboxStateRequest, InboxStateReply, QueryCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getFetchInboxState().getResultCount());
        int i = 0;
        block4: while ((task = batchedTasks.poll()) != null) {
            BatchFetchInboxStateReply.Result result = output.getInboxService().getFetchInboxState().getResult(i++);
            switch (result.getCode()) {
                case OK: {
                    task.resultPromise().complete(InboxStateReply.newBuilder().setReqId(((InboxStateRequest)task.call()).getReqId()).setCode(InboxStateReply.Code.OK).setState(result.getState()).build());
                    continue block4;
                }
                case NO_INBOX: {
                    task.resultPromise().complete(InboxStateReply.newBuilder().setReqId(((InboxStateRequest)task.call()).getReqId()).setCode(InboxStateReply.Code.NO_INBOX).build());
                    continue block4;
                }
            }
            task.resultPromise().complete(InboxStateReply.newBuilder().setReqId(((InboxStateRequest)task.call()).getReqId()).setCode(InboxStateReply.Code.EXPIRED).build());
        }
    }

    protected void handleException(ICallTask<InboxStateRequest, InboxStateReply, QueryCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(InboxStateReply.newBuilder().setReqId(((InboxStateRequest)callTask.call()).getReqId()).setCode(InboxStateReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(InboxStateReply.newBuilder().setReqId(((InboxStateRequest)callTask.call()).getReqId()).setCode(InboxStateReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(InboxStateReply.newBuilder().setReqId(((InboxStateRequest)callTask.call()).getReqId()).setCode(InboxStateReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }
}

