/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.channelclosed.ChannelClosedEvent;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ClientDisconnectEvent;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public final class EventLogger
implements IEventCollector {
    private static final Logger LOG = LoggerFactory.getLogger((String)"DemoEventLogger");

    public void report(Event<?> event) {
        switch (event.type()) {
            case DISCARD: 
            case WILL_DIST_ERROR: 
            case QOS0_DIST_ERROR: 
            case QOS1_DIST_ERROR: 
            case QOS2_DIST_ERROR: 
            case OVERFLOWED: 
            case QOS0_DROPPED: 
            case QOS1_DROPPED: 
            case QOS2_DROPPED: 
            case OVERSIZE_PACKET_DROPPED: 
            case MSG_RETAINED_ERROR: 
            case DELIVER_ERROR: {
                LOG.debug("Message dropped due to {}", (Object)event.type());
                break;
            }
            case OUT_OF_TENANT_RESOURCE: {
                LOG.warn("Out of tenant resource: {}", (Object)((OutOfTenantResource)event).reason());
                break;
            }
            default: {
                if (!(event instanceof ChannelClosedEvent) && !(event instanceof ClientDisconnectEvent)) break;
                LOG.debug("Channel closed due to {}", (Object)event.type());
            }
        }
    }
}

