/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.eventcollector;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class ThreadLocalEventPool {
    private static final Set<Class<? extends Event<?>>> EVENT_TYPES = new HashSet();
    private static final ThreadLocal<IdentityHashMap<Class<? extends Event<?>>, Event<?>>> THREAD_LOCAL_EVENTS;

    private static IdentityHashMap<Class<? extends Event<?>>, Event<?>> init() {
        IdentityHashMap events = new IdentityHashMap(EVENT_TYPES.size());
        EVENT_TYPES.forEach(t -> ThreadLocalEventPool.add(t, events));
        return events;
    }

    private static void add(Class<? extends Event<?>> eventClass, IdentityHashMap<Class<? extends Event<?>>, Event<?>> eventMap) {
        Event<?> event = eventClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        eventMap.put(eventClass, event);
    }

    public static <T extends Event<T>> T getLocal(Class<T> eventClass) {
        return (T)THREAD_LOCAL_EVENTS.get().get(eventClass);
    }

    static {
        Reflections reflections = new Reflections(Event.class.getPackageName(), new Scanner[0]);
        for (Class eventClass : reflections.getSubTypesOf(Event.class)) {
            if (Modifier.isAbstract(eventClass.getModifiers())) continue;
            EVENT_TYPES.add(eventClass);
        }
        THREAD_LOCAL_EVENTS = ThreadLocal.withInitial(ThreadLocalEventPool::init);
    }
}

