/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.resolver;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.entity.CatalogEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.cache.EntityCacheByNameKey;
import org.apache.polaris.core.persistence.cache.EntityCacheLookupResult;
import org.apache.polaris.core.persistence.dao.entity.ChangeTrackingResult;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntityResult;
import org.apache.polaris.core.persistence.resolver.ResolverEntityName;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;

public class Resolver {
    @Nonnull
    private final PolarisCallContext polarisCallContext;
    @Nonnull
    private final PolarisDiagnostics diagnostics;
    @Nonnull
    private final PolarisMetaStoreManager polarisMetaStoreManager;
    @Nullable
    private final EntityCache cache;
    @Nonnull
    private final PolarisPrincipal polarisPrincipal;
    private final String referenceCatalogName;
    private final AbstractSet<ResolverEntityName> entitiesToResolve;
    private final List<ResolverPath> pathsToResolve;
    private ResolvedPolarisEntity resolvedCallerPrincipal;
    private List<ResolvedPolarisEntity> resolvedCallerPrincipalRoles;
    private ResolvedPolarisEntity resolvedReferenceCatalog;
    private final Map<Long, ResolvedPolarisEntity> resolvedCatalogRoles;
    private List<List<ResolvedPolarisEntity>> resolvedPaths;
    private final Map<EntityCacheByNameKey, ResolvedPolarisEntity> resolvedEntriesByName;
    private final Map<Long, ResolvedPolarisEntity> resolvedEntriesById;
    private ResolverStatus resolverStatus;
    private boolean isPassthroughFacade;

    public Resolver(@Nonnull PolarisDiagnostics diagnostics, @Nonnull PolarisCallContext polarisCallContext, @Nonnull PolarisMetaStoreManager polarisMetaStoreManager, @Nonnull PolarisPrincipal principal, @Nullable EntityCache cache, @Nullable String referenceCatalogName) {
        this.polarisCallContext = polarisCallContext;
        this.diagnostics = diagnostics;
        this.polarisMetaStoreManager = polarisMetaStoreManager;
        this.cache = cache;
        this.referenceCatalogName = referenceCatalogName;
        this.diagnostics.checkNotNull(polarisCallContext, "unexpected_null_polarisCallContext");
        this.diagnostics.checkNotNull(polarisMetaStoreManager, "unexpected_null_polarisMetaStoreManager");
        this.diagnostics.checkNotNull(principal, "principal_must_be_specified");
        this.polarisPrincipal = principal;
        this.pathsToResolve = new ArrayList<ResolverPath>();
        this.resolvedPaths = new ArrayList<List<ResolvedPolarisEntity>>();
        this.entitiesToResolve = new HashSet<ResolverEntityName>();
        this.resolvedCallerPrincipalRoles = new ArrayList<ResolvedPolarisEntity>();
        this.resolvedCatalogRoles = referenceCatalogName != null ? new HashMap<Long, ResolvedPolarisEntity>() : null;
        this.resolvedEntriesByName = new HashMap<EntityCacheByNameKey, ResolvedPolarisEntity>();
        this.resolvedEntriesById = new HashMap<Long, ResolvedPolarisEntity>();
        this.resolverStatus = null;
    }

    public void addEntityByName(@Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        this.diagnostics.checkNotNull(entityType, "entity_type_is_null");
        this.diagnostics.checkNotNull(entityName, "entity_name_is_null");
        this.diagnostics.check(this.resolverStatus == null, "resolver_called");
        this.addEntityByName(entityType, entityName, false);
    }

    public void addOptionalEntityByName(@Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        this.diagnostics.checkNotNull(entityType, "entity_type_is_null");
        this.diagnostics.checkNotNull(entityName, "entity_name_is_null");
        this.diagnostics.check(this.resolverStatus == null, "resolver_called");
        this.addEntityByName(entityType, entityName, true);
    }

    public void addPath(@Nonnull ResolverPath path) {
        this.diagnostics.check(this.resolverStatus == null, "resolver_called");
        this.diagnostics.checkNotNull(path, "unexpected_null_entity_path");
        this.pathsToResolve.add(path);
    }

    public ResolverStatus resolveAll() {
        ResolverStatus status;
        this.diagnostics.check(this.resolverStatus == null, "resolver_called");
        int count = 0;
        do {
            status = this.runResolvePass();
            ++count;
        } while (status == null && ++count < 1000);
        this.diagnostics.checkNotNull(status, "cannot_resolve_all_entities");
        this.resolverStatus = status;
        return status;
    }

    public boolean getIsPassthroughFacade() {
        return this.isPassthroughFacade;
    }

    @Nonnull
    public ResolvedPolarisEntity getResolvedCallerPrincipal() {
        this.diagnostics.checkNotNull(this.resolverStatus, "resolver_must_be_called_first");
        this.diagnostics.check(this.resolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS, "resolver_must_be_successful");
        return this.resolvedCallerPrincipal;
    }

    @Nonnull
    public List<ResolvedPolarisEntity> getResolvedCallerPrincipalRoles() {
        this.diagnostics.checkNotNull(this.resolverStatus, "resolver_must_be_called_first");
        this.diagnostics.check(this.resolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS, "resolver_must_be_successful");
        return this.resolvedCallerPrincipalRoles;
    }

    @Nullable
    public ResolvedPolarisEntity getResolvedReferenceCatalog() {
        this.diagnostics.checkNotNull(this.resolverStatus, "resolver_must_be_called_first");
        this.diagnostics.check(this.resolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS, "resolver_must_be_successful");
        return this.resolvedReferenceCatalog;
    }

    @Nullable
    public Map<Long, ResolvedPolarisEntity> getResolvedCatalogRoles() {
        this.diagnostics.checkNotNull(this.resolverStatus, "resolver_must_be_called_first");
        this.diagnostics.check(this.resolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS, "resolver_must_be_successful");
        return this.resolvedCatalogRoles;
    }

    @Nonnull
    public List<ResolvedPolarisEntity> getResolvedPath() {
        this.diagnostics.checkNotNull(this.resolverStatus, "resolver_must_be_called_first");
        this.diagnostics.check(this.resolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS, "resolver_must_be_successful");
        this.diagnostics.check(this.resolvedPaths.size() == 1, "only_if_single");
        return this.resolvedPaths.get(0);
    }

    @Nonnull
    public List<List<ResolvedPolarisEntity>> getResolvedPaths() {
        this.diagnostics.checkNotNull(this.resolverStatus, "resolver_must_be_called_first");
        this.diagnostics.check(this.resolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS, "resolver_must_be_successful");
        this.diagnostics.check(!this.resolvedPaths.isEmpty(), "no_path_resolved");
        return this.resolvedPaths;
    }

    @Nullable
    public ResolvedPolarisEntity getResolvedEntity(@Nonnull PolarisEntityType entityType, @Nonnull String entityName) {
        this.diagnostics.checkNotNull(this.resolverStatus, "resolver_must_be_called_first");
        this.diagnostics.check(this.resolverStatus.getStatus() == ResolverStatus.StatusEnum.SUCCESS, "resolver_must_be_successful");
        this.diagnostics.check(entityType != PolarisEntityType.NAMESPACE && entityType != PolarisEntityType.TABLE_LIKE, "cannot_be_path");
        this.diagnostics.check(entityType.isTopLevel() || this.referenceCatalogName != null, "reference_catalog_expected");
        if (entityType.isTopLevel()) {
            return this.resolvedEntriesByName.get(new EntityCacheByNameKey(entityType, entityName));
        }
        long catalogId = this.resolvedReferenceCatalog.getEntity().getId();
        return this.resolvedEntriesByName.get(new EntityCacheByNameKey(catalogId, catalogId, entityType, entityName));
    }

    private ResolverStatus runResolvePass() {
        boolean validationSuccess;
        this.resolvedCallerPrincipal = null;
        this.resolvedReferenceCatalog = null;
        if (this.resolvedCatalogRoles != null) {
            this.resolvedCatalogRoles.clear();
        }
        this.resolvedCallerPrincipalRoles.clear();
        this.resolvedPaths.clear();
        ArrayList<ResolvedPolarisEntity> toValidate = new ArrayList<ResolvedPolarisEntity>();
        ResolverStatus status = this.resolveCallerPrincipalAndPrincipalRoles(toValidate);
        if (status.getStatus() == ResolverStatus.StatusEnum.SUCCESS) {
            if (this.referenceCatalogName != null) {
                status = this.resolveReferenceCatalog(toValidate, this.referenceCatalogName);
            }
            if (status.getStatus() == ResolverStatus.StatusEnum.SUCCESS && (status = this.resolveEntities(toValidate, this.entitiesToResolve)).getStatus() == ResolverStatus.StatusEnum.SUCCESS && this.referenceCatalogName != null) {
                status = this.resolvePaths(toValidate, this.pathsToResolve);
            }
        }
        if (validationSuccess = this.bulkValidate(toValidate)) {
            this.updateResolved();
        }
        return validationSuccess ? status : null;
    }

    private void updateResolved() {
        this.resolvedCallerPrincipal = this.getFreshlyResolved(this.resolvedCallerPrincipal);
        if (!this.resolvedCallerPrincipalRoles.isEmpty()) {
            this.resolvedCallerPrincipalRoles = this.resolvedCallerPrincipalRoles.stream().map(this::getFreshlyResolved).filter(Objects::nonNull).collect(Collectors.toList());
        }
        this.resolvedReferenceCatalog = this.getFreshlyResolved(this.resolvedReferenceCatalog);
        if (this.resolvedCatalogRoles != null) {
            for (ResolvedPolarisEntity catalogResolvedEntity : this.resolvedCatalogRoles.values()) {
                this.resolvedCatalogRoles.put(catalogResolvedEntity.getEntity().getId(), this.getFreshlyResolved(catalogResolvedEntity));
            }
        }
        if (!this.resolvedPaths.isEmpty()) {
            ArrayList<List<ResolvedPolarisEntity>> refreshedResolvedPaths = new ArrayList<List<ResolvedPolarisEntity>>(this.resolvedPaths.size());
            this.resolvedPaths.forEach(rp -> {
                ArrayList refreshedRp = new ArrayList(rp.size());
                rp.forEach(ce -> refreshedRp.add(this.getFreshlyResolved((ResolvedPolarisEntity)ce)));
                refreshedResolvedPaths.add(refreshedRp);
            });
            this.resolvedPaths = refreshedResolvedPaths;
        }
    }

    private ResolvedPolarisEntity getFreshlyResolved(ResolvedPolarisEntity originalEntity) {
        ResolvedPolarisEntity refreshedEntry;
        if (originalEntity == null) {
            refreshedEntry = null;
        } else {
            refreshedEntry = this.resolvedEntriesById.get(originalEntity.getEntity().getId());
            this.diagnostics.checkNotNull(refreshedEntry, "_entry_should_be_resolved", "entity={}", originalEntity.getEntity());
        }
        return refreshedEntry;
    }

    private boolean bulkValidate(List<ResolvedPolarisEntity> toValidate) {
        if (!this.polarisMetaStoreManager.requiresEntityReload()) {
            return true;
        }
        boolean validationStatus = true;
        if (!toValidate.isEmpty()) {
            List<PolarisEntityId> entityIds = toValidate.stream().map(resolvedEntity -> new PolarisEntityId(resolvedEntity.getEntity().getCatalogId(), resolvedEntity.getEntity().getId())).collect(Collectors.toList());
            ChangeTrackingResult changeTrackingResult = this.polarisMetaStoreManager.loadEntitiesChangeTracking(this.polarisCallContext, entityIds);
            Iterator<ResolvedPolarisEntity> entityIterator = toValidate.iterator();
            Iterator<PolarisChangeTrackingVersions> versionIterator = changeTrackingResult.getChangeTrackingVersions().iterator();
            while (entityIterator.hasNext()) {
                ResolvedPolarisEntity refreshedResolvedEntity;
                ResolvedPolarisEntity resolvedEntity2 = entityIterator.next();
                PolarisChangeTrackingVersions versions = versionIterator.next();
                PolarisEntity entity = resolvedEntity2.getEntity();
                if (versions == null || entity.getEntityVersion() != versions.getEntityVersion() || entity.getGrantRecordsVersion() != versions.getGrantRecordsVersion()) {
                    PolarisEntity refreshedEntity;
                    if (versions == null) {
                        if (this.cache != null) {
                            this.cache.removeCacheEntry(resolvedEntity2);
                        }
                        refreshedResolvedEntity = null;
                    } else {
                        ResolvedEntityResult result;
                        refreshedResolvedEntity = this.cache != null ? this.cache.getAndRefreshIfNeeded(this.polarisCallContext, entity, versions.getEntityVersion(), versions.getGrantRecordsVersion()) : ((result = this.polarisMetaStoreManager.refreshResolvedEntity(this.polarisCallContext, entity.getEntityVersion(), entity.getGrantRecordsVersion(), ((PolarisEntityCore)entity).getType(), entity.getCatalogId(), entity.getId())).isSuccess() ? new ResolvedPolarisEntity(this.diagnostics, result.getEntity() != null ? result.getEntity() : entity, result.getEntityGrantRecords() != null ? result.getEntityGrantRecords() : resolvedEntity2.getAllGrantRecords(), result.getEntityGrantRecords() != null ? result.getGrantRecordsVersion() : entity.getGrantRecordsVersion()) : null);
                    }
                    PolarisEntity polarisEntity = refreshedEntity = refreshedResolvedEntity == null ? null : refreshedResolvedEntity.getEntity();
                    if (refreshedEntity == null || refreshedEntity.getParentId() != entity.getParentId() || refreshedEntity.isDropped() != entity.isDropped() || !refreshedEntity.getName().equals(entity.getName())) {
                        validationStatus = false;
                    }
                    if (entity.getTypeCode() == PolarisEntityType.PRINCIPAL.getCode() || entity.getTypeCode() == PolarisEntityType.PRINCIPAL_ROLE.getCode()) {
                        validationStatus = false;
                    }
                } else {
                    refreshedResolvedEntity = resolvedEntity2;
                }
                if (refreshedResolvedEntity == null) continue;
                this.addToResolved(refreshedResolvedEntity);
            }
        }
        return validationStatus;
    }

    private ResolverStatus resolveEntities(List<ResolvedPolarisEntity> toValidate, AbstractSet<ResolverEntityName> entitiesToResolve) {
        for (ResolverEntityName entityName : entitiesToResolve) {
            ResolvedPolarisEntity resolvedEntity = this.resolveByName(toValidate, entityName.getEntityType(), entityName.getEntityName());
            if (entityName.isOptional() || resolvedEntity != null && !resolvedEntity.getEntity().isDropped()) continue;
            return new ResolverStatus(entityName.getEntityType(), entityName.getEntityName());
        }
        return new ResolverStatus(ResolverStatus.StatusEnum.SUCCESS);
    }

    private ResolverStatus resolvePaths(List<ResolvedPolarisEntity> toValidate, List<ResolverPath> pathsToResolve) {
        long catalogId = this.resolvedReferenceCatalog.getEntity().getId();
        for (ResolverPath path : pathsToResolve) {
            ArrayList<ResolvedPolarisEntity> resolvedPath = new ArrayList<ResolvedPolarisEntity>();
            long parentId = catalogId;
            Iterator<String> pathIt = path.getEntityNames().iterator();
            for (int segmentIndex = 0; segmentIndex < path.getEntityNames().size(); ++segmentIndex) {
                String segmentName = pathIt.next();
                PolarisEntityType segmentType = pathIt.hasNext() ? PolarisEntityType.NAMESPACE : path.getLastEntityType();
                ResolvedPolarisEntity segment = this.resolveByName(toValidate, catalogId, segmentType, parentId, segmentName);
                if (segment == null || segment.getEntity().isDropped()) {
                    if (path.isOptional() || this.isPassthroughFacade) break;
                    return new ResolverStatus(path, segmentIndex);
                }
                parentId = segment.getEntity().getId();
                resolvedPath.add(segment);
            }
            this.resolvedPaths.add(resolvedPath);
        }
        return new ResolverStatus(ResolverStatus.StatusEnum.SUCCESS);
    }

    private ResolverStatus resolveCallerPrincipalAndPrincipalRoles(List<ResolvedPolarisEntity> toValidate) {
        this.resolvedCallerPrincipal = this.resolveByName(toValidate, PolarisEntityType.PRINCIPAL, this.polarisPrincipal.getName());
        if (this.resolvedCallerPrincipal == null || this.resolvedCallerPrincipal.getEntity().isDropped()) {
            return new ResolverStatus(ResolverStatus.StatusEnum.CALLER_PRINCIPAL_DOES_NOT_EXIST);
        }
        this.resolvedCallerPrincipalRoles = this.polarisPrincipal.getRoles().isEmpty() ? this.resolveAllPrincipalRoles(toValidate, this.resolvedCallerPrincipal) : this.resolvePrincipalRolesByName(toValidate, this.polarisPrincipal.getRoles());
        return new ResolverStatus(ResolverStatus.StatusEnum.SUCCESS);
    }

    private List<ResolvedPolarisEntity> resolveAllPrincipalRoles(List<ResolvedPolarisEntity> toValidate, ResolvedPolarisEntity callerPrincipal) {
        return callerPrincipal.getGrantRecordsAsGrantee().stream().filter(gr -> gr.getPrivilegeCode() == PolarisPrivilege.PRINCIPAL_ROLE_USAGE.getCode()).map(gr -> this.resolveById(toValidate, PolarisEntityType.PRINCIPAL_ROLE, PolarisEntityConstants.getRootEntityId(), gr.getSecurableId())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<ResolvedPolarisEntity> resolvePrincipalRolesByName(List<ResolvedPolarisEntity> toValidate, Set<String> roleNames) {
        return roleNames.stream().filter(roleName -> this.polarisPrincipal.getRoles().contains(roleName)).map(roleName -> this.resolveByName(toValidate, PolarisEntityType.PRINCIPAL_ROLE, (String)roleName)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ResolverStatus resolveReferenceCatalog(@Nonnull List<ResolvedPolarisEntity> toValidate, @Nonnull String referenceCatalogName) {
        this.resolvedReferenceCatalog = this.resolveByName(toValidate, PolarisEntityType.CATALOG, referenceCatalogName);
        if (this.resolvedReferenceCatalog == null || this.resolvedReferenceCatalog.getEntity().isDropped()) {
            return new ResolverStatus(PolarisEntityType.CATALOG, this.referenceCatalogName);
        }
        long catalogId = this.resolvedReferenceCatalog.getEntity().getId();
        for (ResolvedPolarisEntity principalRole : this.resolvedCallerPrincipalRoles) {
            for (PolarisGrantRecord grantRecord : principalRole.getGrantRecordsAsGrantee()) {
                ResolvedPolarisEntity catalogRole;
                long catalogRoleId;
                if (grantRecord.getPrivilegeCode() != PolarisPrivilege.CATALOG_ROLE_USAGE.getCode() || grantRecord.getSecurableCatalogId() != catalogId || this.resolvedCatalogRoles.containsKey(catalogRoleId = grantRecord.getSecurableId()) || (catalogRole = this.resolveById(toValidate, PolarisEntityType.CATALOG_ROLE, catalogId, catalogRoleId)) == null || catalogRole.getEntity().isDropped()) continue;
                this.resolvedCatalogRoles.put(catalogRoleId, catalogRole);
            }
        }
        if (CatalogEntity.of(this.resolvedReferenceCatalog.getEntity()).isPassthroughFacade()) {
            this.isPassthroughFacade = true;
        }
        return new ResolverStatus(ResolverStatus.StatusEnum.SUCCESS);
    }

    private void addToResolved(ResolvedPolarisEntity refreshedResolvedEntity) {
        PolarisEntity entity = refreshedResolvedEntity.getEntity();
        this.resolvedEntriesById.put(entity.getId(), refreshedResolvedEntity);
        if (!entity.isDropped()) {
            this.resolvedEntriesByName.put(new EntityCacheByNameKey(entity.getCatalogId(), entity.getParentId(), ((PolarisEntityCore)entity).getType(), entity.getName()), refreshedResolvedEntity);
        }
    }

    private void addEntityByName(@Nonnull PolarisEntityType entityType, @Nonnull String entityName, boolean optional) {
        this.diagnostics.check(this.resolverStatus == null, "resolver_called");
        this.diagnostics.checkNotNull(entityType, "unexpected_null_entity_type");
        this.diagnostics.checkNotNull(entityName, "unexpected_null_entity_name");
        this.diagnostics.check(entityType != PolarisEntityType.CATALOG_ROLE || this.referenceCatalogName != null, "reference_catalog_must_be_specified");
        this.entitiesToResolve.add(new ResolverEntityName(entityType, entityName, optional));
    }

    private ResolvedPolarisEntity resolveByName(List<ResolvedPolarisEntity> toValidate, PolarisEntityType entityType, String entityName) {
        if (entityType.isTopLevel()) {
            return this.resolveByName(toValidate, PolarisEntityConstants.getNullId(), entityType, PolarisEntityConstants.getNullId(), entityName);
        }
        long catalogId = this.resolvedReferenceCatalog.getEntity().getId();
        this.diagnostics.check(entityType == PolarisEntityType.CATALOG_ROLE, "catalog_role_expected");
        return this.resolveByName(toValidate, catalogId, entityType, catalogId, entityName);
    }

    private ResolvedPolarisEntity resolveByName(@Nonnull List<ResolvedPolarisEntity> toValidate, long catalogId, @Nonnull PolarisEntityType entityType, long parentId, @Nonnull String entityName) {
        EntityCacheByNameKey nameKey = new EntityCacheByNameKey(catalogId, parentId, entityType, entityName);
        ResolvedPolarisEntity resolvedEntity = this.resolvedEntriesByName.get(nameKey);
        if (resolvedEntity != null) {
            return resolvedEntity;
        }
        for (ResolvedPolarisEntity ce : toValidate) {
            PolarisEntity entity = ce.getEntity();
            if (entity.getCatalogId() != catalogId || entity.getParentId() != parentId || ((PolarisEntityCore)entity).getType() != entityType || !entity.getName().equals(entityName)) continue;
            return ce;
        }
        if (this.cache != null) {
            EntityCacheLookupResult lookupResult = this.cache.getOrLoadEntityByName(this.polarisCallContext, new EntityCacheByNameKey(catalogId, parentId, entityType, entityName));
            if (lookupResult == null) {
                return null;
            }
            if (lookupResult.isCacheHit()) {
                toValidate.add(lookupResult.getCacheEntry());
            } else {
                this.diagnostics.checkNotNull(lookupResult.getCacheEntry(), "cache_entry_is_null");
                this.addToResolved(lookupResult.getCacheEntry());
            }
            return lookupResult.getCacheEntry();
        }
        ResolvedEntityResult result = this.polarisMetaStoreManager.loadResolvedEntityByName(this.polarisCallContext, catalogId, parentId, entityType, entityName);
        if (!result.isSuccess()) {
            return null;
        }
        resolvedEntity = new ResolvedPolarisEntity(this.diagnostics, result.getEntity(), result.getEntityGrantRecords(), result.getGrantRecordsVersion());
        this.addToResolved(resolvedEntity);
        return resolvedEntity;
    }

    private ResolvedPolarisEntity resolveById(@Nonnull List<ResolvedPolarisEntity> toValidate, @Nonnull PolarisEntityType entityType, long catalogId, long entityId) {
        if (this.cache != null) {
            EntityCacheLookupResult lookupResult = this.cache.getOrLoadEntityById(this.polarisCallContext, catalogId, entityId, entityType);
            if (lookupResult == null) {
                return null;
            }
            if (lookupResult.isCacheHit()) {
                toValidate.add(lookupResult.getCacheEntry());
            } else {
                this.diagnostics.checkNotNull(lookupResult.getCacheEntry(), "cache_entry_is_null");
                this.addToResolved(lookupResult.getCacheEntry());
            }
            return lookupResult.getCacheEntry();
        }
        ResolvedEntityResult result = this.polarisMetaStoreManager.loadResolvedEntityById(this.polarisCallContext, catalogId, entityId, entityType);
        if (!result.isSuccess()) {
            return null;
        }
        ResolvedPolarisEntity resolvedEntity = new ResolvedPolarisEntity(this.diagnostics, result.getEntity(), result.getEntityGrantRecords(), result.getGrantRecordsVersion());
        this.addToResolved(resolvedEntity);
        return resolvedEntity;
    }
}

