/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.ActionStatusService;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector;
import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TransactionStatusConnectionManager {
    private static String _typeName = TransactionStatusManagerItem.typeName();
    private Hashtable _tscTable = new Hashtable();
    private static RecoveryStore _recoveryStore = null;
    private static Uid _localUid = new Uid();

    public TransactionStatusConnectionManager() {
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this.updateTSMI();
    }

    public int getTransactionStatus(Uid tranUid) {
        String transactionType = "";
        int status = this.getTransactionStatus(transactionType, tranUid);
        return status;
    }

    public int getTransactionStatus(String transactionType, Uid tranUid) {
        int status = 9;
        String process_id = tranUid.getHexPid();
        if (!process_id.equals(_localUid.getHexPid())) {
            status = this.getRemoteTransactionStatus(process_id, transactionType, tranUid);
        }
        if (status == 9) {
            ActionStatusService ass = new ActionStatusService();
            try {
                status = ass.getTransactionStatus(transactionType, tranUid.stringForm());
            }
            catch (Exception ex) {
                tsLogger.i18NLogger.warn_recovery_TransactionStatusConnectionManager_1(ex);
            }
        }
        return status;
    }

    private int getRemoteTransactionStatus(String process_id, String transactionType, Uid tranUid) {
        int status = 9;
        if (!this._tscTable.containsKey(process_id)) {
            this.updateTSMI();
        }
        if (this._tscTable.containsKey(process_id)) {
            TransactionStatusConnector tsc = (TransactionStatusConnector)this._tscTable.get(process_id);
            if (tsc.isDead()) {
                this._tscTable.remove(process_id);
                tsc.delete();
                tsc = null;
            } else {
                status = tsc.getTransactionStatus(transactionType, tranUid);
            }
        }
        return status;
    }

    public void updateTSMI() {
        boolean tsmis = false;
        InputObjectState uids = new InputObjectState();
        Vector<Uid> tsmiVector = new Vector<Uid>();
        try {
            tsmis = _recoveryStore.allObjUids(_typeName, uids);
        }
        catch (ObjectStoreException ex) {
            tsLogger.i18NLogger.warn_recovery_TransactionStatusConnectionManager_2(ex);
        }
        if (tsmis) {
            Uid theUid = null;
            boolean moreUids = true;
            while (moreUids) {
                try {
                    theUid = UidHelper.unpackFrom(uids);
                    if (theUid.equals(Uid.nullUid())) {
                        moreUids = false;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    if (tsLogger.logger.isDebugEnabled()) {
                        tsLogger.logger.debug((Object)("found process uid " + String.valueOf(newUid)));
                    }
                    tsmiVector.addElement(newUid);
                }
                catch (Exception ex) {
                    moreUids = false;
                }
            }
        }
        Enumeration tsmiEnum = tsmiVector.elements();
        while (tsmiEnum.hasMoreElements()) {
            Uid currentUid = (Uid)tsmiEnum.nextElement();
            String process_id = currentUid.getHexPid();
            if (this._tscTable.containsKey(process_id)) continue;
            TransactionStatusConnector tsc = new TransactionStatusConnector(process_id, currentUid);
            if (tsc.isDead()) {
                tsc.delete();
                tsc = null;
            } else {
                this._tscTable.put(process_id, tsc);
            }
            if (!tsLogger.logger.isDebugEnabled()) continue;
            tsLogger.logger.debug((Object)("added TransactionStatusConnector to table for process uid " + process_id));
        }
    }
}

