/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.external.tenant;

import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.polaris.service.auth.external.tenant.OidcTenantConfiguration;
import org.apache.polaris.service.auth.external.tenant.OidcTenantResolver;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
public class OidcTenantResolvingAugmentor
implements SecurityIdentityAugmentor {
    public static final String TENANT_CONFIG_ATTRIBUTE = "polaris-tenant-config";
    public static final int PRIORITY = 1200;
    private final OidcTenantResolver resolver;

    public static OidcTenantConfiguration getOidcTenantConfig(SecurityIdentity identity) {
        return (OidcTenantConfiguration)identity.getAttribute(TENANT_CONFIG_ATTRIBUTE);
    }

    @Inject
    public OidcTenantResolvingAugmentor(OidcTenantResolver resolver) {
        this.resolver = resolver;
    }

    public int priority() {
        return 1200;
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous() || !(identity.getPrincipal() instanceof JsonWebToken)) {
            return Uni.createFrom().item((Object)identity);
        }
        return Uni.createFrom().item(() -> this.setOidcTenantConfig(identity));
    }

    private SecurityIdentity setOidcTenantConfig(SecurityIdentity identity) {
        OidcTenantConfiguration config = this.resolver.resolveConfig(identity);
        return QuarkusSecurityIdentity.builder((SecurityIdentity)identity).addAttribute(TENANT_CONFIG_ATTRIBUTE, (Object)config).build();
    }
}

