/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DoubleRange;
import software.amazon.awssdk.services.rds.model.DoubleRangeListCopier;
import software.amazon.awssdk.services.rds.model.Range;
import software.amazon.awssdk.services.rds.model.RangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidStorageOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidStorageOptions> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(ValidStorageOptions.getter(ValidStorageOptions::storageType)).setter(ValidStorageOptions.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<List<Range>> STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageSize").getter(ValidStorageOptions.getter(ValidStorageOptions::storageSize)).setter(ValidStorageOptions.setter(Builder::storageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build(), ListTrait.builder().memberLocationName("Range").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build()).build()}).build();
    private static final SdkField<List<Range>> PROVISIONED_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisionedIops").getter(ValidStorageOptions.getter(ValidStorageOptions::provisionedIops)).setter(ValidStorageOptions.setter(Builder::provisionedIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedIops").build(), ListTrait.builder().memberLocationName("Range").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build()).build()}).build();
    private static final SdkField<List<DoubleRange>> IOPS_TO_STORAGE_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IopsToStorageRatio").getter(ValidStorageOptions.getter(ValidStorageOptions::iopsToStorageRatio)).setter(ValidStorageOptions.setter(Builder::iopsToStorageRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsToStorageRatio").build(), ListTrait.builder().memberLocationName("DoubleRange").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DoubleRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleRange").build()}).build()).build()}).build();
    private static final SdkField<List<Range>> PROVISIONED_STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisionedStorageThroughput").getter(ValidStorageOptions.getter(ValidStorageOptions::provisionedStorageThroughput)).setter(ValidStorageOptions.setter(Builder::provisionedStorageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedStorageThroughput").build(), ListTrait.builder().memberLocationName("Range").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()}).build()).build()}).build();
    private static final SdkField<List<DoubleRange>> STORAGE_THROUGHPUT_TO_IOPS_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageThroughputToIopsRatio").getter(ValidStorageOptions.getter(ValidStorageOptions::storageThroughputToIopsRatio)).setter(ValidStorageOptions.setter(Builder::storageThroughputToIopsRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughputToIopsRatio").build(), ListTrait.builder().memberLocationName("DoubleRange").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DoubleRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleRange").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_STORAGE_AUTOSCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsStorageAutoscaling").getter(ValidStorageOptions.getter(ValidStorageOptions::supportsStorageAutoscaling)).setter(ValidStorageOptions.setter(Builder::supportsStorageAutoscaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageAutoscaling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, STORAGE_SIZE_FIELD, PROVISIONED_IOPS_FIELD, IOPS_TO_STORAGE_RATIO_FIELD, PROVISIONED_STORAGE_THROUGHPUT_FIELD, STORAGE_THROUGHPUT_TO_IOPS_RATIO_FIELD, SUPPORTS_STORAGE_AUTOSCALING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidStorageOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String storageType;
    private final List<Range> storageSize;
    private final List<Range> provisionedIops;
    private final List<DoubleRange> iopsToStorageRatio;
    private final List<Range> provisionedStorageThroughput;
    private final List<DoubleRange> storageThroughputToIopsRatio;
    private final Boolean supportsStorageAutoscaling;

    private ValidStorageOptions(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.storageSize = builder.storageSize;
        this.provisionedIops = builder.provisionedIops;
        this.iopsToStorageRatio = builder.iopsToStorageRatio;
        this.provisionedStorageThroughput = builder.provisionedStorageThroughput;
        this.storageThroughputToIopsRatio = builder.storageThroughputToIopsRatio;
        this.supportsStorageAutoscaling = builder.supportsStorageAutoscaling;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final boolean hasStorageSize() {
        return this.storageSize != null && !(this.storageSize instanceof SdkAutoConstructList);
    }

    public final List<Range> storageSize() {
        return this.storageSize;
    }

    public final boolean hasProvisionedIops() {
        return this.provisionedIops != null && !(this.provisionedIops instanceof SdkAutoConstructList);
    }

    public final List<Range> provisionedIops() {
        return this.provisionedIops;
    }

    public final boolean hasIopsToStorageRatio() {
        return this.iopsToStorageRatio != null && !(this.iopsToStorageRatio instanceof SdkAutoConstructList);
    }

    public final List<DoubleRange> iopsToStorageRatio() {
        return this.iopsToStorageRatio;
    }

    public final boolean hasProvisionedStorageThroughput() {
        return this.provisionedStorageThroughput != null && !(this.provisionedStorageThroughput instanceof SdkAutoConstructList);
    }

    public final List<Range> provisionedStorageThroughput() {
        return this.provisionedStorageThroughput;
    }

    public final boolean hasStorageThroughputToIopsRatio() {
        return this.storageThroughputToIopsRatio != null && !(this.storageThroughputToIopsRatio instanceof SdkAutoConstructList);
    }

    public final List<DoubleRange> storageThroughputToIopsRatio() {
        return this.storageThroughputToIopsRatio;
    }

    public final Boolean supportsStorageAutoscaling() {
        return this.supportsStorageAutoscaling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageSize() ? this.storageSize() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedIops() ? this.provisionedIops() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIopsToStorageRatio() ? this.iopsToStorageRatio() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisionedStorageThroughput() ? this.provisionedStorageThroughput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageThroughputToIopsRatio() ? this.storageThroughputToIopsRatio() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsStorageAutoscaling());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidStorageOptions)) {
            return false;
        }
        ValidStorageOptions other = (ValidStorageOptions)obj;
        return Objects.equals(this.storageType(), other.storageType()) && this.hasStorageSize() == other.hasStorageSize() && Objects.equals(this.storageSize(), other.storageSize()) && this.hasProvisionedIops() == other.hasProvisionedIops() && Objects.equals(this.provisionedIops(), other.provisionedIops()) && this.hasIopsToStorageRatio() == other.hasIopsToStorageRatio() && Objects.equals(this.iopsToStorageRatio(), other.iopsToStorageRatio()) && this.hasProvisionedStorageThroughput() == other.hasProvisionedStorageThroughput() && Objects.equals(this.provisionedStorageThroughput(), other.provisionedStorageThroughput()) && this.hasStorageThroughputToIopsRatio() == other.hasStorageThroughputToIopsRatio() && Objects.equals(this.storageThroughputToIopsRatio(), other.storageThroughputToIopsRatio()) && Objects.equals(this.supportsStorageAutoscaling(), other.supportsStorageAutoscaling());
    }

    public final String toString() {
        return ToString.builder((String)"ValidStorageOptions").add("StorageType", (Object)this.storageType()).add("StorageSize", this.hasStorageSize() ? this.storageSize() : null).add("ProvisionedIops", this.hasProvisionedIops() ? this.provisionedIops() : null).add("IopsToStorageRatio", this.hasIopsToStorageRatio() ? this.iopsToStorageRatio() : null).add("ProvisionedStorageThroughput", this.hasProvisionedStorageThroughput() ? this.provisionedStorageThroughput() : null).add("StorageThroughputToIopsRatio", this.hasStorageThroughputToIopsRatio() ? this.storageThroughputToIopsRatio() : null).add("SupportsStorageAutoscaling", (Object)this.supportsStorageAutoscaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "StorageSize": {
                return Optional.ofNullable(clazz.cast(this.storageSize()));
            }
            case "ProvisionedIops": {
                return Optional.ofNullable(clazz.cast(this.provisionedIops()));
            }
            case "IopsToStorageRatio": {
                return Optional.ofNullable(clazz.cast(this.iopsToStorageRatio()));
            }
            case "ProvisionedStorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedStorageThroughput()));
            }
            case "StorageThroughputToIopsRatio": {
                return Optional.ofNullable(clazz.cast(this.storageThroughputToIopsRatio()));
            }
            case "SupportsStorageAutoscaling": {
                return Optional.ofNullable(clazz.cast(this.supportsStorageAutoscaling()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("StorageSize", STORAGE_SIZE_FIELD);
        map.put("ProvisionedIops", PROVISIONED_IOPS_FIELD);
        map.put("IopsToStorageRatio", IOPS_TO_STORAGE_RATIO_FIELD);
        map.put("ProvisionedStorageThroughput", PROVISIONED_STORAGE_THROUGHPUT_FIELD);
        map.put("StorageThroughputToIopsRatio", STORAGE_THROUGHPUT_TO_IOPS_RATIO_FIELD);
        map.put("SupportsStorageAutoscaling", SUPPORTS_STORAGE_AUTOSCALING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidStorageOptions, T> g) {
        return obj -> g.apply((ValidStorageOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageType;
        private List<Range> storageSize = DefaultSdkAutoConstructList.getInstance();
        private List<Range> provisionedIops = DefaultSdkAutoConstructList.getInstance();
        private List<DoubleRange> iopsToStorageRatio = DefaultSdkAutoConstructList.getInstance();
        private List<Range> provisionedStorageThroughput = DefaultSdkAutoConstructList.getInstance();
        private List<DoubleRange> storageThroughputToIopsRatio = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsStorageAutoscaling;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidStorageOptions model) {
            this.storageType(model.storageType);
            this.storageSize(model.storageSize);
            this.provisionedIops(model.provisionedIops);
            this.iopsToStorageRatio(model.iopsToStorageRatio);
            this.provisionedStorageThroughput(model.provisionedStorageThroughput);
            this.storageThroughputToIopsRatio(model.storageThroughputToIopsRatio);
            this.supportsStorageAutoscaling(model.supportsStorageAutoscaling);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final List<Range.Builder> getStorageSize() {
            List<Range.Builder> result = RangeListCopier.copyToBuilder(this.storageSize);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageSize(Collection<Range.BuilderImpl> storageSize) {
            this.storageSize = RangeListCopier.copyFromBuilder(storageSize);
        }

        @Override
        public final Builder storageSize(Collection<Range> storageSize) {
            this.storageSize = RangeListCopier.copy(storageSize);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Range ... storageSize) {
            this.storageSize(Arrays.asList(storageSize));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSize(Consumer<Range.Builder> ... storageSize) {
            this.storageSize(Stream.of(storageSize).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Range.Builder> getProvisionedIops() {
            List<Range.Builder> result = RangeListCopier.copyToBuilder(this.provisionedIops);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedIops(Collection<Range.BuilderImpl> provisionedIops) {
            this.provisionedIops = RangeListCopier.copyFromBuilder(provisionedIops);
        }

        @Override
        public final Builder provisionedIops(Collection<Range> provisionedIops) {
            this.provisionedIops = RangeListCopier.copy(provisionedIops);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Range ... provisionedIops) {
            this.provisionedIops(Arrays.asList(provisionedIops));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedIops(Consumer<Range.Builder> ... provisionedIops) {
            this.provisionedIops(Stream.of(provisionedIops).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DoubleRange.Builder> getIopsToStorageRatio() {
            List<DoubleRange.Builder> result = DoubleRangeListCopier.copyToBuilder(this.iopsToStorageRatio);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIopsToStorageRatio(Collection<DoubleRange.BuilderImpl> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copyFromBuilder(iopsToStorageRatio);
        }

        @Override
        public final Builder iopsToStorageRatio(Collection<DoubleRange> iopsToStorageRatio) {
            this.iopsToStorageRatio = DoubleRangeListCopier.copy(iopsToStorageRatio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(DoubleRange ... iopsToStorageRatio) {
            this.iopsToStorageRatio(Arrays.asList(iopsToStorageRatio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iopsToStorageRatio(Consumer<DoubleRange.Builder> ... iopsToStorageRatio) {
            this.iopsToStorageRatio(Stream.of(iopsToStorageRatio).map(c -> (DoubleRange)((DoubleRange.Builder)DoubleRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Range.Builder> getProvisionedStorageThroughput() {
            List<Range.Builder> result = RangeListCopier.copyToBuilder(this.provisionedStorageThroughput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedStorageThroughput(Collection<Range.BuilderImpl> provisionedStorageThroughput) {
            this.provisionedStorageThroughput = RangeListCopier.copyFromBuilder(provisionedStorageThroughput);
        }

        @Override
        public final Builder provisionedStorageThroughput(Collection<Range> provisionedStorageThroughput) {
            this.provisionedStorageThroughput = RangeListCopier.copy(provisionedStorageThroughput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedStorageThroughput(Range ... provisionedStorageThroughput) {
            this.provisionedStorageThroughput(Arrays.asList(provisionedStorageThroughput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedStorageThroughput(Consumer<Range.Builder> ... provisionedStorageThroughput) {
            this.provisionedStorageThroughput(Stream.of(provisionedStorageThroughput).map(c -> (Range)((Range.Builder)Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DoubleRange.Builder> getStorageThroughputToIopsRatio() {
            List<DoubleRange.Builder> result = DoubleRangeListCopier.copyToBuilder(this.storageThroughputToIopsRatio);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageThroughputToIopsRatio(Collection<DoubleRange.BuilderImpl> storageThroughputToIopsRatio) {
            this.storageThroughputToIopsRatio = DoubleRangeListCopier.copyFromBuilder(storageThroughputToIopsRatio);
        }

        @Override
        public final Builder storageThroughputToIopsRatio(Collection<DoubleRange> storageThroughputToIopsRatio) {
            this.storageThroughputToIopsRatio = DoubleRangeListCopier.copy(storageThroughputToIopsRatio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageThroughputToIopsRatio(DoubleRange ... storageThroughputToIopsRatio) {
            this.storageThroughputToIopsRatio(Arrays.asList(storageThroughputToIopsRatio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageThroughputToIopsRatio(Consumer<DoubleRange.Builder> ... storageThroughputToIopsRatio) {
            this.storageThroughputToIopsRatio(Stream.of(storageThroughputToIopsRatio).map(c -> (DoubleRange)((DoubleRange.Builder)DoubleRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSupportsStorageAutoscaling() {
            return this.supportsStorageAutoscaling;
        }

        public final void setSupportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
        }

        @Override
        public final Builder supportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
            return this;
        }

        public ValidStorageOptions build() {
            return new ValidStorageOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidStorageOptions> {
        public Builder storageType(String var1);

        public Builder storageSize(Collection<Range> var1);

        public Builder storageSize(Range ... var1);

        public Builder storageSize(Consumer<Range.Builder> ... var1);

        public Builder provisionedIops(Collection<Range> var1);

        public Builder provisionedIops(Range ... var1);

        public Builder provisionedIops(Consumer<Range.Builder> ... var1);

        public Builder iopsToStorageRatio(Collection<DoubleRange> var1);

        public Builder iopsToStorageRatio(DoubleRange ... var1);

        public Builder iopsToStorageRatio(Consumer<DoubleRange.Builder> ... var1);

        public Builder provisionedStorageThroughput(Collection<Range> var1);

        public Builder provisionedStorageThroughput(Range ... var1);

        public Builder provisionedStorageThroughput(Consumer<Range.Builder> ... var1);

        public Builder storageThroughputToIopsRatio(Collection<DoubleRange> var1);

        public Builder storageThroughputToIopsRatio(DoubleRange ... var1);

        public Builder storageThroughputToIopsRatio(Consumer<DoubleRange.Builder> ... var1);

        public Builder supportsStorageAutoscaling(Boolean var1);
    }
}

