/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class ProjectOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ProjectOperator.class);
    private final OperatorContext operatorContext;
    private final Operator child;
    private final List<Integer> remainingColumnIndexList;

    public ProjectOperator(OperatorContext operatorContext, Operator child, List<Integer> remainingColumnIndexList) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.remainingColumnIndexList = Objects.requireNonNull(remainingColumnIndexList, "remainingInputLocations is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock input = this.child.nextWithTimer();
        if (input == null) {
            return null;
        }
        Column[] valueColumns = new Column[this.remainingColumnIndexList.size()];
        for (int i = 0; i < this.remainingColumnIndexList.size(); ++i) {
            valueColumns[i] = input.getColumn(this.remainingColumnIndexList.get(i).intValue());
        }
        return new TsBlock(input.getPositionCount(), input.getTimeColumn(), valueColumns);
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.child.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.child.calculateMaxPeekMemory();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

