/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v1.impl;

import java.lang.invoke.LambdaMetafactory;
import java.time.ZoneId;
import java.util.Optional;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.utils.InsertTabletSortDataUtils;
import org.apache.iotdb.db.protocol.rest.v1.RestApiService;
import org.apache.iotdb.db.protocol.rest.v1.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.ExecuteStatementHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.StatementConstructionHandler;
import org.apache.iotdb.db.protocol.rest.v1.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.v1.model.SQL;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.LocalExecutionPlanner;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateTableViewStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;

public class RestApiServiceImpl
extends RestApiService {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private final AuthorizationHandler authorizationHandler = new AuthorizationHandler();
    private final Integer defaultQueryRowLimit = IoTDBRestServiceDescriptor.getInstance().getConfig().getRestQueryDefaultRowSizeLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Response executeNonQueryStatement(SQL sql, SecurityContext securityContext) {
        block21: {
            block22: {
                block20: {
                    block19: {
                        queryId = null;
                        startTime = System.nanoTime();
                        finish = false;
                        statement = null;
                        RequestValidationHandler.validateSQL(sql);
                        statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
                        if (statement != null) break block19;
                        var8_7 = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SQL_PARSE_ERROR.getStatusCode())).message("This operation type is not supported")).build();
                        costTime = System.nanoTime() - startTime;
                        Optional.ofNullable(statement).ifPresent((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$executeNonQueryStatement$0(long org.apache.iotdb.db.queryengine.plan.statement.Statement ), (Lorg/apache/iotdb/db/queryengine/plan/statement/Statement;)V)((long)costTime));
                        if (queryId != null) {
                            if (finish) {
                                executeTime = RestApiServiceImpl.COORDINATOR.getTotalExecutionTime(queryId);
                                CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                            }
                            RestApiServiceImpl.COORDINATOR.cleanupQueryExecution(queryId);
                        }
                        return var8_7;
                    }
                    if (ExecuteStatementHandler.validateStatement(statement)) break block20;
                    var8_8 = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                    costTime = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$executeNonQueryStatement$0(long org.apache.iotdb.db.queryengine.plan.statement.Statement ), (Lorg/apache/iotdb/db/queryengine/plan/statement/Statement;)V)((long)costTime));
                    if (queryId != null) {
                        if (finish) {
                            executeTime = RestApiServiceImpl.COORDINATOR.getTotalExecutionTime(queryId);
                            CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                        }
                        RestApiServiceImpl.COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return var8_8;
                }
                queryId = RestApiServiceImpl.SESSION_MANAGER.requestQueryId();
                if (!(statement instanceof CreateTableViewStatement)) break block22;
                result = RestApiServiceImpl.COORDINATOR.executeForTableModel(((CreateTableViewStatement)statement).getCreateTableView(), new SqlParser(), RestApiServiceImpl.SESSION_MANAGER.getCurrSession(), queryId, RestApiServiceImpl.SESSION_MANAGER.getSessionInfo(RestApiServiceImpl.SESSION_MANAGER.getCurrSession()), sql.getSql(), LocalExecutionPlanner.getInstance().metadata, RestApiServiceImpl.config.getQueryTimeoutThreshold(), false);
                ** GOTO lbl51
            }
            response = this.authorizationHandler.checkAuthority(securityContext, statement);
            if (response == null) break block21;
            var10_17 = response;
            costTime = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$executeNonQueryStatement$0(long org.apache.iotdb.db.queryengine.plan.statement.Statement ), (Lorg/apache/iotdb/db/queryengine/plan/statement/Statement;)V)((long)costTime));
            if (queryId != null) {
                if (finish) {
                    executeTime = RestApiServiceImpl.COORDINATOR.getTotalExecutionTime(queryId);
                    CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                }
                RestApiServiceImpl.COORDINATOR.cleanupQueryExecution(queryId);
            }
            return var10_17;
        }
        try {
            result = RestApiServiceImpl.COORDINATOR.executeForTreeModel(statement, queryId, RestApiServiceImpl.SESSION_MANAGER.getSessionInfo(RestApiServiceImpl.SESSION_MANAGER.getCurrSession()), sql.getSql(), this.partitionFetcher, this.schemaFetcher, RestApiServiceImpl.config.getQueryTimeoutThreshold(), false);
lbl51:
            // 2 sources

            finish = true;
            var9_13 = Response.ok().entity((Object)(result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() ? new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage()))).build();
        }
        catch (Exception e) {
            try {
                finish = true;
                var9_13 = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
            catch (Throwable var15_23) {
                costTime = System.nanoTime() - startTime;
                Optional.ofNullable(statement).ifPresent((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$executeNonQueryStatement$0(long org.apache.iotdb.db.queryengine.plan.statement.Statement ), (Lorg/apache/iotdb/db/queryengine/plan/statement/Statement;)V)((long)costTime));
                if (queryId != null) {
                    if (finish) {
                        executeTime = RestApiServiceImpl.COORDINATOR.getTotalExecutionTime(queryId);
                        CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                    }
                    RestApiServiceImpl.COORDINATOR.cleanupQueryExecution(queryId);
                }
                throw var15_23;
            }
            costTime = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$executeNonQueryStatement$0(long org.apache.iotdb.db.queryengine.plan.statement.Statement ), (Lorg/apache/iotdb/db/queryengine/plan/statement/Statement;)V)((long)costTime));
            if (queryId != null) {
                if (finish) {
                    executeTime = RestApiServiceImpl.COORDINATOR.getTotalExecutionTime(queryId);
                    CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                }
                RestApiServiceImpl.COORDINATOR.cleanupQueryExecution(queryId);
            }
            return var9_13;
        }
        costTime = System.nanoTime() - startTime;
        Optional.ofNullable(statement).ifPresent((Consumer<Statement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$executeNonQueryStatement$0(long org.apache.iotdb.db.queryengine.plan.statement.Statement ), (Lorg/apache/iotdb/db/queryengine/plan/statement/Statement;)V)((long)costTime));
        if (queryId != null) {
            if (finish) {
                executeTime = RestApiServiceImpl.COORDINATOR.getTotalExecutionTime(queryId);
                CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
            }
            RestApiServiceImpl.COORDINATOR.cleanupQueryExecution(queryId);
        }
        return var9_13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Response executeQueryStatement(SQL sql, SecurityContext securityContext) {
        ExecutionResult result;
        Statement statement;
        boolean finish;
        long startTime;
        Long queryId;
        block30: {
            block29: {
                block28: {
                    block27: {
                        queryId = null;
                        startTime = System.nanoTime();
                        finish = false;
                        statement = null;
                        RequestValidationHandler.validateSQL(sql);
                        statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
                        if (statement != null) break block27;
                        Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SQL_PARSE_ERROR.getStatusCode())).message("This operation type is not supported")).build();
                        long costTime = System.nanoTime() - startTime;
                        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                        if (queryId != null) {
                            if (finish) {
                                long executeTime = COORDINATOR.getTotalExecutionTime(queryId);
                                CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                            }
                            COORDINATOR.cleanupQueryExecution(queryId);
                        }
                        return response;
                    }
                    if (!ExecuteStatementHandler.validateStatement(statement)) break block28;
                    Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                    long costTime = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                    if (queryId != null) {
                        if (finish) {
                            long executeTime = COORDINATOR.getTotalExecutionTime(queryId);
                            CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                        }
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response;
                }
                Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
                if (response == null) break block29;
                Response costTime = response;
                long costTime2 = System.nanoTime() - startTime;
                Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                if (queryId != null) {
                    if (finish) {
                        long executeTime3222 = COORDINATOR.getTotalExecutionTime(queryId);
                        CommonUtils.addQueryLatency(statement.getType(), executeTime3222 > 0L ? executeTime3222 : costTime2);
                    }
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return costTime;
            }
            queryId = SESSION_MANAGER.requestQueryId();
            result = COORDINATOR.executeForTreeModel(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), sql.getSql(), this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold(), true);
            finish = true;
            if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block30;
            Response costTime2 = Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
            long costTime = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
            if (queryId != null) {
                if (finish) {
                    long executeTime = COORDINATOR.getTotalExecutionTime(queryId);
                    CommonUtils.addQueryLatency(statement.getType(), executeTime > 0L ? executeTime : costTime);
                }
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return costTime2;
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        Response executeTime3222 = QueryDataSetHandler.fillQueryDataSet(queryExecution, statement, sql.getRowLimit() == null ? this.defaultQueryRowLimit : sql.getRowLimit());
        threadName.close();
        long costTime = System.nanoTime() - startTime;
        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
        if (queryId != null) {
            if (finish) {
                long executeTime2 = COORDINATOR.getTotalExecutionTime(queryId);
                CommonUtils.addQueryLatency(statement.getType(), executeTime2 > 0L ? executeTime2 : costTime);
            }
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return executeTime3222;
        {
            catch (Throwable executeTime3222) {
                try {
                    try {
                        try {
                            threadName.close();
                        }
                        catch (Throwable throwable) {
                            executeTime3222.addSuppressed(throwable);
                        }
                        throw executeTime3222;
                    }
                    catch (Exception e) {
                        finish = true;
                        Response response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                        long costTime3 = System.nanoTime() - startTime;
                        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                        if (queryId != null) {
                            if (finish) {
                                long executeTime4 = COORDINATOR.getTotalExecutionTime(queryId);
                                CommonUtils.addQueryLatency(statement.getType(), executeTime4 > 0L ? executeTime4 : costTime3);
                            }
                            COORDINATOR.cleanupQueryExecution(queryId);
                        }
                        return response;
                    }
                }
                catch (Throwable throwable) {
                    long costTime4 = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                    if (queryId != null) {
                        if (finish) {
                            long executeTime5 = COORDINATOR.getTotalExecutionTime(queryId);
                            CommonUtils.addQueryLatency(statement.getType(), executeTime5 > 0L ? executeTime5 : costTime4);
                        }
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response insertTablet(InsertTabletRequest insertTabletRequest, SecurityContext securityContext) {
        long costTime;
        Response costTime22;
        Long queryId = null;
        long startTime = System.nanoTime();
        InsertTabletStatement insertTabletStatement = null;
        try {
            RequestValidationHandler.validateInsertTabletRequest(insertTabletRequest);
            if (!InsertTabletSortDataUtils.checkSorted(insertTabletRequest.getTimestamps())) {
                int[] index = InsertTabletSortDataUtils.sortTimeStampList(insertTabletRequest.getTimestamps());
                insertTabletRequest.getTimestamps().sort(Long::compareTo);
                insertTabletRequest.setValues(InsertTabletSortDataUtils.sortList(insertTabletRequest.getValues(), index, insertTabletRequest.getDataTypes().size()));
            }
            startTime = System.nanoTime();
            insertTabletStatement = StatementConstructionHandler.constructInsertTabletStatement(insertTabletRequest);
            Response response = this.authorizationHandler.checkAuthority(securityContext, insertTabletStatement);
            if (response != null) {
                Response response2 = response;
                long costTime22 = System.nanoTime() - startTime;
                Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime22));
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return response2;
            }
            queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.executeForTreeModel(insertTabletStatement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold(), false);
            costTime22 = Response.ok().entity((Object)(result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() ? new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage()))).build();
            costTime = System.nanoTime() - startTime;
        }
        catch (Exception e) {
            Response response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            return response;
        }
        finally {
            long costTime3 = System.nanoTime() - startTime;
            Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime22));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
        }
        Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime22));
        if (queryId != null) {
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return costTime22;
    }

    private static /* synthetic */ void lambda$executeNonQueryStatement$0(long costTime, Statement s) {
        CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.getType().name(), costTime);
    }
}

