/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ArrayDeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.MetaMarker;
import org.apache.tsfile.file.header.ChunkGroupHeader;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.reader.page.PageReader;
import org.apache.tsfile.read.reader.page.TimePageReader;
import org.apache.tsfile.read.reader.page.ValuePageReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(TsFileResourceUtils.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String VALIDATE_FAILED = "validate failed,";

    private TsFileResourceUtils() {
    }

    public static boolean validateTsFileResourceCorrectness(TsFileResource resource) {
        if (resource.isDeleted()) {
            return true;
        }
        try {
            ArrayDeviceTimeIndex timeIndex = resource.getTimeIndexType() == 2 ? resource.buildDeviceTimeIndex() : (ArrayDeviceTimeIndex)resource.getTimeIndex();
            if (timeIndex == null) {
                logger.error("{} {} time index is null", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                return false;
            }
            Set<IDeviceID> devices = timeIndex.getDevices();
            if (devices.isEmpty()) {
                logger.error("{} {} empty resource", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                return false;
            }
            for (IDeviceID device : devices) {
                long endTime;
                long startTime = timeIndex.getStartTime(device).get();
                if (startTime <= (endTime = timeIndex.getEndTime(device).get().longValue())) continue;
                logger.error("{} {} the start time of {} is greater than end time", new Object[]{resource.getTsFilePath(), VALIDATE_FAILED, device});
                return false;
            }
        }
        catch (IOException e) {
            logger.error("meet error when validate .resource file:{},e", (Object)resource.getTsFilePath());
            return false;
        }
        return true;
    }

    public static boolean validateTsFileIsComplete(TsFileResource resource) {
        if (resource.getTsFile().exists() && resource.getTsFile().length() < (long)"TsFile".getBytes().length * 2L + 1L) {
            logger.error(String.format("target file %s is smaller than magic string and version number size", resource));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateTsFileDataCorrectness(TsFileResource resource) {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(resource.getTsFilePath());){
            byte marker;
            if (!reader.isComplete()) {
                logger.error("{} {} illegal tsfile", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                boolean bl = false;
                return bl;
            }
            Map<Long, IChunkMetadata> chunkMetadataMap = TsFileResourceUtils.getChunkMetadata(reader);
            if (chunkMetadataMap.isEmpty()) {
                logger.error("{} {} there is no data in the file", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                boolean bl = false;
                return bl;
            }
            ArrayList alignedTimeBatches = new ArrayList();
            HashMap<String, Integer> valueColumn2TimeBatchIndex = new HashMap<String, Integer>();
            reader.position((long)"TsFile".getBytes().length + 1L);
            int pageIndex = 0;
            block21: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        int dataSize;
                        long chunkOffset = reader.position();
                        ChunkHeader header = reader.readChunkHeader(marker);
                        IChunkMetadata chunkMetadata = chunkMetadataMap.get(chunkOffset - 1L);
                        if (!chunkMetadata.getMeasurementUid().equals(header.getMeasurementID())) {
                            logger.error("{} chunk start offset is inconsistent with the value in the metadata.", (Object)VALIDATE_FAILED);
                            boolean bl = false;
                            return bl;
                        }
                        String measurement = header.getMeasurementID();
                        List<long[]> alignedTimeBatch = null;
                        if (header.getDataType() == TSDataType.VECTOR) {
                            alignedTimeBatch = new ArrayList();
                            alignedTimeBatches.add(alignedTimeBatch);
                        } else if (marker == 69 || marker == 65) {
                            int timeBatchIndex = valueColumn2TimeBatchIndex.getOrDefault(measurement, 0);
                            valueColumn2TimeBatchIndex.put(measurement, timeBatchIndex + 1);
                            alignedTimeBatch = (List)alignedTimeBatches.get(timeBatchIndex);
                        }
                        if ((dataSize = header.getDataSize()) == 0) continue block21;
                        boolean isHasStatistic = (header.getChunkType() & 0x3F) == 1;
                        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                        pageIndex = 0;
                        LinkedList<Long> lastNoAlignedPageTimeStamps = new LinkedList<Long>();
                        while (true) {
                            long pageHeaderEndTime;
                            long pageHeaderStartTime;
                            if (dataSize <= 0) continue block21;
                            valueDecoder.reset();
                            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), isHasStatistic);
                            ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                            if ((header.getChunkType() & 0xFFFFFF80) == -128) {
                                TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, defaultTimeDecoder);
                                long[] pageTimestamps = timePageReader.getNextTimeBatch();
                                pageHeaderStartTime = isHasStatistic ? pageHeader.getStartTime() : chunkMetadata.getStartTime();
                                long l = pageHeaderEndTime = isHasStatistic ? pageHeader.getEndTime() : chunkMetadata.getEndTime();
                                if (!TsFileResourceUtils.validateTimeFrame(alignedTimeBatch, pageTimestamps, pageHeaderStartTime, pageHeaderEndTime, resource)) {
                                    boolean bl = false;
                                    return bl;
                                }
                                alignedTimeBatch.add(pageTimestamps);
                            } else if ((header.getChunkType() & 0x40) == 64) {
                                ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, header.getDataType(), valueDecoder);
                                valuePageReader.nextValueBatch((long[])alignedTimeBatch.get(pageIndex));
                            } else {
                                PageReader pageReader = new PageReader(pageData, header.getDataType(), valueDecoder, defaultTimeDecoder);
                                BatchData batchData = pageReader.getAllSatisfiedPageData();
                                pageHeaderStartTime = isHasStatistic ? pageHeader.getStartTime() : chunkMetadata.getStartTime();
                                pageHeaderEndTime = isHasStatistic ? pageHeader.getEndTime() : chunkMetadata.getEndTime();
                                long pageStartTime = Long.MAX_VALUE;
                                long previousTime = Long.MIN_VALUE;
                                while (batchData.hasCurrent()) {
                                    long currentTime = batchData.currentTime();
                                    if (!lastNoAlignedPageTimeStamps.isEmpty() && currentTime <= (Long)lastNoAlignedPageTimeStamps.getLast()) {
                                        logger.error("{} {} time ranges overlap between pages.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                        boolean bl = false;
                                        return bl;
                                    }
                                    if (currentTime <= previousTime) {
                                        logger.error("{} {} the timestamp in the page is repeated or not incremental.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                        boolean bl = false;
                                        return bl;
                                    }
                                    pageStartTime = Math.min(pageStartTime, currentTime);
                                    previousTime = currentTime;
                                    lastNoAlignedPageTimeStamps.add(currentTime);
                                    batchData.next();
                                }
                                if (pageHeaderStartTime != pageStartTime) {
                                    logger.error("{} {} the start time in page is different from that in page header.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                    boolean bl = false;
                                    return bl;
                                }
                                if (pageHeaderEndTime != previousTime) {
                                    logger.error("{} {} the end time in page is different from that in page header.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            ++pageIndex;
                            dataSize -= pageHeader.getSerializedPageSize();
                        }
                    }
                    case 0: {
                        valueColumn2TimeBatchIndex.clear();
                        alignedTimeBatches.clear();
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        if (chunkGroupHeader.getDeviceID() != null && !chunkGroupHeader.getDeviceID().isEmpty()) continue block21;
                        logger.error("{} {} device id is null or empty.", (Object)resource.getTsFilePath(), (Object)VALIDATE_FAILED);
                        boolean bl = false;
                        return bl;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block21;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            return true;
        }
        catch (IOException | ArrayIndexOutOfBoundsException | IllegalArgumentException | NegativeArraySizeException e) {
            logger.error("Meets error when validating TsFile {}, ", (Object)resource.getTsFilePath(), (Object)e);
            return false;
        }
    }

    private static boolean validateTimeFrame(List<long[]> timeBatch, long[] pageTimestamps, long pageHeaderStartTime, long pageHeaderEndTime, TsFileResource tsFileResource) {
        long[] lastPageTimes;
        if (pageHeaderStartTime != pageTimestamps[0]) {
            logger.error("{} {} the start time in page is different from that in page header.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        if (pageHeaderEndTime != pageTimestamps[pageTimestamps.length - 1]) {
            logger.error("{} {} the end time in page is different from that in page header.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        for (int i = 0; i < pageTimestamps.length - 1; ++i) {
            if (pageTimestamps[i + 1] > pageTimestamps[i]) continue;
            logger.error("{} {} the timestamp in the page is repeated or not incremental.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        if (timeBatch.size() >= 1 && (lastPageTimes = timeBatch.get(timeBatch.size() - 1))[lastPageTimes.length - 1] >= pageTimestamps[0]) {
            logger.error("{} {} time ranges overlap between pages.", (Object)tsFileResource.getTsFilePath(), (Object)VALIDATE_FAILED);
            return false;
        }
        return true;
    }

    public static Map<Long, IChunkMetadata> getChunkMetadata(TsFileSequenceReader reader) throws IOException {
        HashMap<Long, IChunkMetadata> offset2ChunkMetadata = new HashMap<Long, IChunkMetadata>();
        Map device2Metadata = reader.getAllTimeseriesMetadata(true);
        for (Map.Entry entry : device2Metadata.entrySet()) {
            for (TimeseriesMetadata timeseriesMetadata : (List)entry.getValue()) {
                for (IChunkMetadata chunkMetadata : timeseriesMetadata.getChunkMetadataList()) {
                    offset2ChunkMetadata.put(chunkMetadata.getOffsetOfChunkHeader(), chunkMetadata);
                }
            }
        }
        return offset2ChunkMetadata;
    }

    public static boolean validateTsFileResourcesHasNoOverlap(List<TsFileResource> resources) {
        HashMap<IDeviceID, Pair> lastEndTimeMap = new HashMap<IDeviceID, Pair>();
        for (TsFileResource resource : resources) {
            ArrayDeviceTimeIndex timeIndex;
            block7: {
                if (resource.getTimeIndexType() == 2) {
                    try {
                        timeIndex = CompactionUtils.buildDeviceTimeIndex(resource);
                        break block7;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                timeIndex = (ArrayDeviceTimeIndex)resource.getTimeIndex();
            }
            if (timeIndex == null) {
                return false;
            }
            Set<IDeviceID> devices = timeIndex.getDevices();
            for (IDeviceID device : devices) {
                long currentStartTime = timeIndex.getStartTime(device).get();
                long currentEndTime = timeIndex.getEndTime(device).get();
                Pair lastDeviceInfo = lastEndTimeMap.computeIfAbsent(device, x -> new Pair(null, (Object)Long.MIN_VALUE));
                long lastEndTime = (Long)lastDeviceInfo.right;
                if (lastEndTime >= currentStartTime) {
                    logger.error("Device {} is overlapped between {} and {}, end time in {} is {}, start time in {} is {}", new Object[]{device.toString(), lastDeviceInfo.left, resource, lastDeviceInfo.left, lastEndTime, resource, currentStartTime});
                    return false;
                }
                lastDeviceInfo.left = resource;
                lastDeviceInfo.right = currentEndTime;
                lastEndTimeMap.put(device, lastDeviceInfo);
            }
        }
        return true;
    }

    public static void updateTsFileResource(TsFileSequenceReader reader, TsFileResource tsFileResource) throws IOException {
        TsFileResourceUtils.updateTsFileResource(reader.getAllTimeseriesMetadata(false), tsFileResource, false);
        tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
        tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
    }

    public static void updateTsFileResource(Map<IDeviceID, List<TimeseriesMetadata>> device2Metadata, TsFileResource tsFileResource, boolean cacheLastValue) {
        ITimeIndex newTimeIndex = tsFileResource.getTimeIndex().getTimeIndexType() == 2 ? config.getTimeIndexLevel().getTimeIndex() : tsFileResource.getTimeIndex();
        Map<IDeviceID, List<Pair<String, TimeValuePair>>> deviceLastValues = tsFileResource.getLastValues();
        long lastValueMemCost = 0L;
        if (cacheLastValue && deviceLastValues == null) {
            deviceLastValues = new HashMap<IDeviceID, List<Pair<String, TimeValuePair>>>(device2Metadata.size());
        }
        for (Map.Entry<IDeviceID, List<TimeseriesMetadata>> entry : device2Metadata.entrySet()) {
            ArrayList<Pair> seriesLastValues = null;
            if (deviceLastValues != null) {
                seriesLastValues = new ArrayList<Pair>(entry.getValue().size());
            }
            for (TimeseriesMetadata timeseriesMetaData : entry.getValue()) {
                newTimeIndex.updateStartTime(entry.getKey(), timeseriesMetaData.getStatistics().getStartTime());
                newTimeIndex.updateEndTime(entry.getKey(), timeseriesMetaData.getStatistics().getEndTime());
                if (deviceLastValues == null) continue;
                if (timeseriesMetaData.getTsDataType() != TSDataType.BLOB) {
                    TsPrimitiveType value = TsPrimitiveType.getByType((TSDataType)(timeseriesMetaData.getTsDataType() == TSDataType.VECTOR ? TSDataType.INT64 : timeseriesMetaData.getTsDataType()), (Object)timeseriesMetaData.getStatistics().getLastValue());
                    seriesLastValues.add(new Pair((Object)timeseriesMetaData.getMeasurementId(), (Object)new TimeValuePair(timeseriesMetaData.getStatistics().getEndTime(), value)));
                    continue;
                }
                seriesLastValues.add(new Pair((Object)timeseriesMetaData.getMeasurementId(), null));
            }
            if (deviceLastValues == null) continue;
            lastValueMemCost += entry.getKey().ramBytesUsed();
            for (Pair lastValue : seriesLastValues) {
                if (lastValue == null) continue;
                lastValueMemCost += RamUsageEstimator.shallowSizeOf((Object)lastValue);
                lastValueMemCost += RamUsageEstimator.sizeOf((String)((String)lastValue.left));
                TimeValuePair right = (TimeValuePair)lastValue.getRight();
                lastValueMemCost += right != null ? (long)right.getSize() : (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            }
            lastValueMemCost += (long)seriesLastValues.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
            if ((lastValueMemCost += RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY) <= config.getCacheLastValuesMemoryBudgetInByte()) {
                deviceLastValues.computeIfAbsent(entry.getKey(), deviceID -> new ArrayList()).addAll(seriesLastValues);
                continue;
            }
            deviceLastValues = null;
        }
        tsFileResource.setTimeIndex(newTimeIndex);
        tsFileResource.setLastValues(deviceLastValues);
    }

    public static TsFileResource generateTsFileResource(TsFileIOWriter writer) {
        TsFileResource resource = new TsFileResource(writer.getFile());
        for (ChunkGroupMetadata chunkGroupMetadata : writer.getChunkGroupMetadataList()) {
            IDeviceID device = chunkGroupMetadata.getDevice();
            for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                resource.updateStartTime(device, chunkMetadata.getStartTime());
                resource.updateEndTime(device, chunkMetadata.getEndTime());
            }
        }
        resource.setStatus(TsFileResourceStatus.NORMAL);
        return resource;
    }
}

