/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.migration;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.james.backends.cassandra.migration.MigrationTask;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;

public class MigrationTaskDTO
implements TaskDTO {
    private final int targetVersion;
    private final String type;

    public static TaskDTOModule<MigrationTask, MigrationTaskDTO> module(MigrationTask.Factory factory) {
        return (TaskDTOModule)DTOModule.forDomainObject(MigrationTask.class).convertToDTO(MigrationTaskDTO.class).toDomainObjectConverter(dto -> factory.create(new SchemaVersion(dto.targetVersion))).toDTOConverter((task, type) -> new MigrationTaskDTO(type, task.getTarget().getValue())).typeName(MigrationTask.CASSANDRA_MIGRATION.asString()).withFactory(TaskDTOModule::new);
    }

    MigrationTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="targetVersion") int targetVersion) {
        this.type = type;
        this.targetVersion = targetVersion;
    }

    public String getType() {
        return this.type;
    }

    public int getTargetVersion() {
        return this.targetVersion;
    }
}

