/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionState;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyConstants;
import org.apache.james.imapserver.netty.NettyImapRequestLineReader;
import org.apache.james.imapserver.netty.NettyStreamImapRequestLineReader;
import org.apache.james.imapserver.netty.SwitchableLineBasedFrameDecoder;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.protocols.netty.LineHandlerAware;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class ImapRequestFrameDecoder
extends ByteToMessageDecoder
implements NettyConstants,
LineHandlerAware {
    @VisibleForTesting
    static final String NEEDED_DATA = "NEEDED_DATA";
    private static final boolean RETRY = true;
    private static final String SINK = "SINK";
    private static final String SUBSCRIPTION = "SUBSCRIPTION";
    public static final int UNAUTHENTICATE_LITERAL_MAX_SIZE = Optional.ofNullable(System.getProperty("james.imap.unauthenticated.literal.max.size")).map(Integer::parseInt).orElse(8192);
    private static final String SHOULD_BUFFER = "should_buffer";
    private final ImapDecoder decoder;
    private final int inMemorySizeLimit;
    private final int literalSizeLimit;
    private final Deque<ChannelInboundHandlerAdapter> behaviourOverrides = new ConcurrentLinkedDeque<ChannelInboundHandlerAdapter>();
    private final int maxFrameLength;
    private final AtomicBoolean framingEnabled = new AtomicBoolean(true);
    private ArrayList<byte[]> pending = new ArrayList();

    public ImapRequestFrameDecoder(ImapDecoder decoder, int inMemorySizeLimit, int literalSizeLimit, int maxFrameLength) {
        this.decoder = decoder;
        this.inMemorySizeLimit = inMemorySizeLimit;
        this.literalSizeLimit = literalSizeLimit;
        this.maxFrameLength = maxFrameLength;
    }

    private int literalSizeLimit(ImapSession session) {
        if (session == null) {
            return UNAUTHENTICATE_LITERAL_MAX_SIZE;
        }
        return switch (session.getState()) {
            default -> throw new MatchException(null, null);
            case ImapSessionState.NON_AUTHENTICATED, ImapSessionState.LOGOUT -> UNAUTHENTICATE_LITERAL_MAX_SIZE;
            case ImapSessionState.AUTHENTICATED, ImapSessionState.SELECTED -> this.literalSizeLimit;
        };
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().attr(FRAME_DECODE_ATTACHMENT_ATTRIBUTE_KEY).set(new ConcurrentHashMap());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Object subscription = ((Map)ctx.channel().attr(FRAME_DECODE_ATTACHMENT_ATTRIBUTE_KEY).get()).get(SUBSCRIPTION);
        if (subscription instanceof Disposable) {
            ((Disposable)subscription).dispose();
        }
        super.channelInactive(ctx);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ChannelInboundHandlerAdapter override = this.behaviourOverrides.peekFirst();
        if (override != null) {
            override.channelRead(ctx, (Object)in);
            return;
        }
        int readerIndex = in.readerIndex();
        Map attachment = (Map)ctx.channel().attr(FRAME_DECODE_ATTACHMENT_ATTRIBUTE_KEY).get();
        Pair<ImapRequestLineReader, Integer> readerAndSize = this.obtainReader(ctx, in, attachment, readerIndex);
        if (readerAndSize == null) {
            return;
        }
        this.parseImapMessage(ctx, in, attachment, readerAndSize, readerIndex).ifPresent(out::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ImapMessage> parseImapMessage(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, Pair<ImapRequestLineReader, Integer> readerAndSize, int readerIndex) throws DecodingException {
        ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
        if (session != null && session.getState() != ImapSessionState.LOGOUT) {
            try {
                ImapMessage message = this.decoder.decode((ImapRequestLineReader)readerAndSize.getLeft(), session);
                if ((Integer)readerAndSize.getRight() == -1) {
                    try {
                        ((ImapRequestLineReader)readerAndSize.getLeft()).consumeLine();
                    }
                    catch (DecodingException | NettyImapRequestLineReader.NotEnoughDataException throwable) {
                        // empty catch block
                    }
                }
                this.enableFraming(ctx);
                attachment.clear();
                if (!this.pending.isEmpty()) {
                    this.pending.clear();
                }
                Optional<ImapMessage> optional = Optional.of(message);
                return optional;
            }
            catch (NettyImapRequestLineReader.NotEnoughDataException e) {
                this.requestMoreData(ctx, in, attachment, e.getNeededSize(), readerIndex);
            }
            finally {
                attachment.remove(SHOULD_BUFFER);
            }
        }
        if (ctx.channel().isActive()) {
            ctx.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return Optional.empty();
    }

    private void requestMoreData(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, int neededData, int readerIndex) {
        Boolean shouldBuffer = Optional.ofNullable(attachment.get(SHOULD_BUFFER)).map(Boolean.class::cast).orElse(true);
        if (shouldBuffer.booleanValue()) {
            int i = in.readerIndex();
            in.readerIndex(readerIndex);
            byte[] bytes = new byte[in.readableBytes()];
            in.readBytes(bytes);
            this.pending.add(bytes);
            in.readerIndex(i);
            attachment.put(NEEDED_DATA, neededData - bytes.length);
        } else {
            attachment.put(NEEDED_DATA, neededData);
        }
        this.disableFraming(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Pair<ImapRequestLineReader, Integer> obtainReader(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, int readerIndex) throws IOException {
        NettyImapRequestLineReader reader;
        boolean retry = false;
        int size = -1;
        Object rawSize = attachment.get(NEEDED_DATA);
        if (rawSize != null) {
            retry = true;
            size = (Integer)rawSize;
            if (size != -1) {
                if (this.inMemorySizeLimit > 0 && this.inMemorySizeLimit < size) {
                    ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
                    int literalSizeLimit = this.literalSizeLimit(session);
                    if (literalSizeLimit > 0 && size > literalSizeLimit) {
                        throw new IOException("Attempt to write a too big chunk into a file. " + size + " and limit " + literalSizeLimit);
                    }
                    this.uploadToAFile(ctx, in, attachment, size, readerIndex);
                    return null;
                }
                int readableBytes = in.readableBytes();
                byte[] bytes = new byte[readableBytes];
                in.readBytes(bytes);
                this.pending.add(bytes);
                int totalSize = this.pending.stream().mapToInt(m -> ((byte[])m).length).sum();
                if (totalSize < size) return null;
                ByteBuf byteBufs = Unpooled.wrappedBuffer((byte[][])((byte[][])this.pending.toArray(x$0 -> new byte[x$0][])));
                ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
                attachment.put(SHOULD_BUFFER, false);
                reader = new NettyImapRequestLineReader(ctx.channel(), byteBufs, retry, readerIndex, this.literalSizeLimit(session), this.maxFrameLength);
                return Pair.of((Object)reader, (Object)size);
            } else if (this.pending.isEmpty()) {
                ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
                reader = new NettyImapRequestLineReader(ctx.channel(), in, retry, readerIndex, this.literalSizeLimit(session), this.maxFrameLength);
                return Pair.of((Object)reader, (Object)size);
            } else {
                ByteBuf byteBufs = Unpooled.wrappedBuffer((byte[][])((byte[][])this.pending.toArray(x$0 -> new byte[x$0][])));
                ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
                reader = new NettyImapRequestLineReader(ctx.channel(), byteBufs, retry, readerIndex, this.literalSizeLimit(session), this.maxFrameLength);
            }
            return Pair.of((Object)reader, (Object)size);
        } else {
            ImapSession session = (ImapSession)ctx.channel().attr(IMAP_SESSION_ATTRIBUTE_KEY).get();
            reader = new NettyImapRequestLineReader(ctx.channel(), in, retry, readerIndex, this.literalSizeLimit(session), this.maxFrameLength);
        }
        return Pair.of((Object)reader, (Object)size);
    }

    private void uploadToAFile(ChannelHandlerContext ctx, ByteBuf in, Map<String, Object> attachment, int size, int readerIndex) throws IOException {
        Pair sink;
        if (attachment.containsKey(SINK)) {
            sink = (Pair)attachment.get(SINK);
        } else {
            sink = Pair.of((Object)Sinks.many().unicast().onBackpressureBuffer(), (Object)new AtomicInteger(0));
            attachment.put(SINK, sink);
            FileChunkConsumer fileChunkConsumer = new FileChunkConsumer(size + this.pending.stream().mapToInt(b -> ((byte[])b).length).sum());
            Disposable subscribe = ((Sinks.Many)sink.getLeft()).asFlux().publishOn(Schedulers.boundedElastic()).subscribe((Consumer)fileChunkConsumer, e -> {
                fileChunkConsumer.discard();
                ctx.fireExceptionCaught(e);
            }, () -> {
                fileChunkConsumer.finalizeDataTransfer();
                NettyStreamImapRequestLineReader reader = new NettyStreamImapRequestLineReader(ctx.channel(), fileChunkConsumer.getFile(), true, this.maxFrameLength);
                Object removed = attachment.remove(SUBSCRIPTION);
                try {
                    this.parseImapMessage(ctx, null, attachment, (Pair<ImapRequestLineReader, Integer>)Pair.of((Object)reader, (Object)size), readerIndex).ifPresent(arg_0 -> ((ChannelHandlerContext)ctx).fireChannelRead(arg_0));
                }
                catch (Exception e) {
                    if (removed instanceof Disposable) {
                        ((Disposable)removed).dispose();
                    }
                    ctx.fireExceptionCaught((Throwable)e);
                }
            });
            attachment.put(SUBSCRIPTION, () -> {
                subscribe.dispose();
                fileChunkConsumer.discard();
            });
            this.pending.forEach(bytes -> ((Sinks.Many)sink.getLeft()).emitNext(bytes, Sinks.EmitFailureHandler.FAIL_FAST));
            this.pending.clear();
        }
        int readableBytes = in.readableBytes();
        byte[] bytes2 = new byte[readableBytes];
        in.readBytes(bytes2);
        ((Sinks.Many)sink.getLeft()).emitNext((Object)bytes2, Sinks.EmitFailureHandler.FAIL_FAST);
        if (((AtomicInteger)sink.getRight()).addAndGet(readableBytes) >= size) {
            ((Sinks.Many)sink.getLeft()).tryEmitComplete();
        }
    }

    public void disableFraming(ChannelHandlerContext ctx) {
        if (this.framingEnabled.getAndSet(false)) {
            ctx.channel().pipeline().replace("framer", "framer", (ChannelHandler)new ChannelInboundHandlerAdapter(this){});
        }
    }

    public void enableFraming(ChannelHandlerContext ctx) {
        if (!this.framingEnabled.getAndSet(true)) {
            ctx.channel().pipeline().replace("framer", "framer", (ChannelHandler)new SwitchableLineBasedFrameDecoder(ctx.channel().pipeline(), this.maxFrameLength, false));
        }
    }

    public void pushLineHandler(ChannelInboundHandlerAdapter lineHandlerUpstreamHandler) {
        this.behaviourOverrides.addFirst(lineHandlerUpstreamHandler);
    }

    public void popLineHandler() {
        if (!this.behaviourOverrides.isEmpty()) {
            this.behaviourOverrides.removeFirst();
        }
    }

    static class FileChunkConsumer
    implements Consumer<byte[]> {
        private final int size;
        private final AtomicInteger written = new AtomicInteger(0);
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private OutputStream outputStream;
        private FileHolder file;

        FileChunkConsumer(int size) {
            this.size = size;
        }

        public FileHolder getFile() {
            return this.file;
        }

        @Override
        public void accept(byte[] next) {
            if (!this.initialized.get()) {
                this.initialize();
            }
            this.writeChunk(next);
        }

        private void initialize() {
            try {
                this.file = FileHolder.create();
                this.outputStream = new FileOutputStream(this.file.getFile(), true);
                this.initialized.set(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void writeChunk(byte[] next) {
            try {
                int amount = Math.min(next.length, this.size - this.written.get());
                this.outputStream.write(next, 0, amount);
                this.written.addAndGet(amount);
            }
            catch (Exception e) {
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException(e);
            }
        }

        private void finalizeDataTransfer() {
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void discard() {
            Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                if (this.file != null) {
                    this.file.dispose();
                }
            })).subscribeOn(Schedulers.boundedElastic()).subscribe();
        }
    }

    public static class FileHolder
    extends Disposable.LeakAware<FileHolderInner> {
        private final FileHolderInner file;

        public static FileHolder create() throws IOException {
            return new FileHolder(FileHolderInner.create());
        }

        private FileHolder(FileHolderInner file) {
            super((Disposable.LeakAware.Resource)file);
            this.file = file;
        }

        public File getFile() {
            return this.file.file;
        }
    }

    public static class FileHolderInner
    extends Disposable.LeakAware.Resource {
        private final File file;

        public static FileHolderInner create() throws IOException {
            return new FileHolderInner(Files.createTempFile("imap-literal", ".tmp", new FileAttribute[0]).toFile());
        }

        private FileHolderInner(File file) {
            super(() -> FileUtils.deleteQuietly((File)file));
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

