/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.util.LongHeap;
import org.apache.lucene.util.hnsw.HnswGraph;

public class UpdateGraphsUtils {
    public static Set<Integer> computeJoinSet(HnswGraph graph) throws IOException {
        int k;
        int size = graph.size();
        LongHeap heap = new LongHeap(size);
        HashSet<Integer> j = new HashSet<Integer>();
        boolean[] stale = new boolean[size];
        short[] counts = new short[size];
        long gExit = 0L;
        for (int v = 0; v < size; ++v) {
            graph.seek(0, v);
            int degree = graph.neighborCount();
            k = degree < 9 ? 2 : Math.ceilDiv(degree, 4);
            gExit += (long)k;
            int gain = k + degree;
            heap.push(UpdateGraphsUtils.encode(gain, v));
        }
        long gTot = 0L;
        while (gTot < gExit && heap.size() > 0) {
            long el = heap.pop();
            int gain = UpdateGraphsUtils.decodeValue1(el);
            int v = UpdateGraphsUtils.decodeValue2(el);
            graph.seek(0, v);
            int degree = graph.neighborCount();
            int[] ns = new int[degree];
            int i = 0;
            int u = graph.nextNeighbor();
            while (u != Integer.MAX_VALUE) {
                ns[i++] = u;
                u = graph.nextNeighbor();
            }
            int n = k = degree < 9 ? 2 : Math.ceilDiv(degree, 4);
            if (stale[v]) {
                int newGain = Math.max(0, k - counts[v]);
                for (int u2 : ns) {
                    if (counts[u2] >= k || j.contains(u2)) continue;
                    ++newGain;
                }
                if (newGain <= 0) continue;
                heap.push(UpdateGraphsUtils.encode(newGain, v));
                stale[v] = false;
                continue;
            }
            j.add(v);
            gTot += (long)gain;
            boolean markNeighboursStale = counts[v] < k;
            for (int u2 : ns) {
                if (markNeighboursStale) {
                    stale[u2] = true;
                }
                if (counts[u2] < k - 1) {
                    graph.seek(0, u2);
                    int uu = graph.nextNeighbor();
                    while (uu != Integer.MAX_VALUE) {
                        stale[uu] = true;
                        uu = graph.nextNeighbor();
                    }
                }
                int n2 = u2;
                counts[n2] = (short)(counts[n2] + 1);
            }
        }
        return j;
    }

    private static long encode(int value1, int value2) {
        return (long)(-value1) << 32 | (long)value2 & 0xFFFFFFFFL;
    }

    private static int decodeValue1(long encoded) {
        return (int)(-(encoded >> 32));
    }

    private static int decodeValue2(long encoded) {
        return (int)(encoded & 0xFFFFFFFFL);
    }
}

