/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.leviathan;

import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.RandomLib;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;

public class rnd
extends FunctionBase {
    @Override
    public NodeValue exec(List<NodeValue> args) {
        if (args.size() > 2) {
            throw new ExprEvalException("Too many arguments");
        }
        switch (args.size()) {
            case 0: {
                return NodeValue.makeDouble(RandomLib.random.nextDouble());
            }
            case 1: {
                double max2 = args.get(0).getDouble();
                if (max2 <= 0.0) {
                    throw new ExprEvalException("Max must be > 0");
                }
                return NodeValue.makeDouble(RandomLib.random.nextDouble() * max2);
            }
            case 2: {
                double min2 = args.get(0).getDouble();
                double max3 = args.get(1).getDouble();
                if (min2 > max3) {
                    throw new ExprEvalException("Min cannot be greater than the max");
                }
                double range = max3 - min2;
                double value = min2 + RandomLib.random.nextDouble() * range;
                return NodeValue.makeDouble(value);
            }
        }
        throw new ExprEvalException("Too many arguments");
    }

    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() > 2) {
            throw new QueryBuildException("Function '" + Lib.className((Object)this) + "' takes between 0, 1 or 2 argument(s)");
        }
    }
}

