/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.analyzer;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.jena.query.text.analyzer.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingMultilingualAnalyzer
extends DelegatingAnalyzerWrapper {
    private static Logger log = LoggerFactory.getLogger(IndexingMultilingualAnalyzer.class);
    private Analyzer defaultAnalyzer;

    public IndexingMultilingualAnalyzer(Analyzer defaultAnalyzer) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        int idx = fieldName.lastIndexOf("_");
        if (idx == -1) {
            return this.defaultAnalyzer;
        }
        String lang = fieldName.substring(idx + 1);
        Analyzer analyzer = Util.getIndexAnalyzer(lang);
        analyzer = ObjectUtils.getIfNull(analyzer, Util.getLocalizedAnalyzer(lang));
        analyzer = ObjectUtils.getIfNull(analyzer, this.defaultAnalyzer);
        log.trace("getWrappedAnalyzer fieldName: {}, analyzer: {}", (Object)fieldName, (Object)analyzer);
        return analyzer;
    }

    public String toString() {
        return "IndexingMultilingualAnalyzer(default=" + String.valueOf(this.defaultAnalyzer) + ")";
    }
}

