/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Deque;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.swagger.HeaderInfo;
import org.apache.juneau.bean.swagger.SchemaInfo;
import org.apache.juneau.bean.swagger.Swagger;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class ResponseInfo
extends SwaggerElement {
    private String description;
    private SchemaInfo schema;
    private Map<String, HeaderInfo> headers = CollectionUtils.map();
    private Map<String, Object> examples = CollectionUtils.map();

    public ResponseInfo() {
    }

    public ResponseInfo(ResponseInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        SchemaInfo schemaInfo = this.schema = copyFrom.schema == null ? null : copyFrom.schema.copy();
        if (Utils.nn(copyFrom.examples)) {
            this.examples.putAll(CollectionUtils.copyOf(copyFrom.examples));
        }
        if (Utils.nn(copyFrom.headers)) {
            this.headers.putAll(CollectionUtils.copyOf(copyFrom.headers, HeaderInfo::copy));
        }
    }

    public ResponseInfo addExample(String mimeType, Object example) {
        AssertionUtils.assertArgNotNull("mimeType", mimeType);
        AssertionUtils.assertArgNotNull("example", example);
        this.examples.put(mimeType, example);
        return this;
    }

    public ResponseInfo addHeader(String name, HeaderInfo header) {
        AssertionUtils.assertArgNotNull("name", name);
        AssertionUtils.assertArgNotNull("header", header);
        this.headers.put(name, header);
        return this;
    }

    public ResponseInfo copy() {
        return new ResponseInfo(this);
    }

    public ResponseInfo copyFrom(ResponseInfo r) {
        if (Utils.nn(r)) {
            if (Utils.nn(r.description)) {
                this.description = r.description;
            }
            if (Utils.nn(r.schema)) {
                this.schema = r.schema;
            }
            if (Utils.nn(r.headers)) {
                this.headers = r.headers;
            }
            if (Utils.nn(r.examples)) {
                this.examples = r.examples;
            }
        }
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            case "headers" -> ConverterUtils.toType(this.getHeaders(), type);
            case "schema" -> ConverterUtils.toType(this.getSchema(), type);
            default -> super.get(property, type);
        };
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getExamples() {
        return Utils.nullIfEmpty(this.examples);
    }

    public HeaderInfo getHeader(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        return this.headers.get(name);
    }

    public Map<String, HeaderInfo> getHeaders() {
        return Utils.nullIfEmpty(this.headers);
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.description), "description").addIf(Utils.ne(this.examples), "examples").addIf(Utils.ne(this.headers), "headers").addIf(Utils.nn(this.schema), "schema").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public ResponseInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (Utils.nn(this.schema)) {
            this.schema = this.schema.resolveRefs(swagger, refStack, maxDepth);
        }
        this.headers.entrySet().forEach(x -> x.setValue(((HeaderInfo)x.getValue()).resolveRefs(swagger, refStack, maxDepth)));
        return this;
    }

    @Override
    public ResponseInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> this.setDescription(Utils.s(value));
            case "examples" -> this.setExamples(ConverterUtils.toMapBuilder(value, String.class, Object.class).sparse().build());
            case "headers" -> this.setHeaders(ConverterUtils.toMapBuilder(value, String.class, HeaderInfo.class).sparse().build());
            case "schema" -> this.setSchema(ConverterUtils.toType(value, SchemaInfo.class));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public ResponseInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public ResponseInfo setExamples(Map<String, Object> value) {
        this.examples.clear();
        if (Utils.nn(value)) {
            this.examples.putAll(value);
        }
        return this;
    }

    public ResponseInfo setHeaders(Map<String, HeaderInfo> value) {
        this.headers.clear();
        if (Utils.nn(value)) {
            this.headers.putAll(value);
        }
        return this;
    }

    public ResponseInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    @Override
    public ResponseInfo strict() {
        super.strict();
        return this;
    }

    @Override
    public ResponseInfo strict(Object value) {
        super.strict(value);
        return this;
    }
}

