/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.c2.protocol.component.api.DefinedType;
import org.apache.nifi.c2.protocol.component.api.PropertyDescriptor;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedPropertyDescriptor;
import org.apache.nifi.minifi.commons.service.FlowPropertyEncryptor;

public class StandardFlowPropertyEncryptor
implements FlowPropertyEncryptor {
    private static final String ENCRYPTED_FORMAT = "enc{%s}";
    private final PropertyEncryptor propertyEncryptor;
    private final RuntimeManifest runTimeManifest;

    public StandardFlowPropertyEncryptor(PropertyEncryptor propertyEncryptor, RuntimeManifest runTimeManifest) {
        this.propertyEncryptor = propertyEncryptor;
        this.runTimeManifest = runTimeManifest;
    }

    public void encryptSensitiveProperties(VersionedDataflow flow) {
        this.encryptParameterContextsProperties(flow);
        Map sensitivePropertiesByComponentType = Optional.of(this.flowProvidedSensitiveProperties(flow)).filter(Predicate.not(Map::isEmpty)).orElseGet(this::runtimeManifestSensitiveProperties);
        this.encryptFlowComponentsProperties(flow, sensitivePropertiesByComponentType);
    }

    private void encryptParameterContextsProperties(VersionedDataflow flow) {
        Optional.ofNullable(flow.getParameterContexts()).orElse(List.of()).forEach(parameterContext -> Optional.ofNullable(parameterContext.getParameters()).orElse(Set.of()).stream().filter(VersionedParameter::isSensitive).filter(Predicate.not(parameter -> Optional.ofNullable(parameter.getValue()).orElse("").startsWith("enc{"))).forEach(parameter -> parameter.setValue(this.encrypt(parameter.getValue()))));
    }

    private Map<String, Set<String>> flowProvidedSensitiveProperties(VersionedDataflow flow) {
        return this.fetchFlowComponents(flow).map(extension -> Map.entry(extension.getType(), Optional.ofNullable(extension.getPropertyDescriptors()).orElse(Map.of()).values().stream().filter(VersionedPropertyDescriptor::isSensitive).map(VersionedPropertyDescriptor::getName).collect(Collectors.toSet()))).filter(Predicate.not(entry -> ((Set)entry.getValue()).isEmpty())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, this::mergeSets));
    }

    private Map<String, Set<String>> runtimeManifestSensitiveProperties() {
        return Optional.ofNullable(this.runTimeManifest).map(RuntimeManifest::getBundles).orElse(List.of()).stream().flatMap(bundle -> Stream.of(Optional.ofNullable(bundle.getComponentManifest().getProcessors()).orElse(List.of()), Optional.ofNullable(bundle.getComponentManifest().getControllerServices()).orElse(List.of()))).flatMap(Collection::stream).collect(Collectors.toMap(DefinedType::getType, type -> Optional.ofNullable(type.getPropertyDescriptors()).orElse(Map.of()).values().stream().filter(PropertyDescriptor::getSensitive).map(PropertyDescriptor::getName).collect(Collectors.toSet()), this::mergeSets));
    }

    private void encryptFlowComponentsProperties(VersionedDataflow flow, Map<String, Set<String>> sensitivePropertiesByComponentType) {
        this.fetchFlowComponents(flow).forEach(extension -> {
            Set<String> sensitivePropertyNames = sensitivePropertiesByComponentType.getOrDefault(extension.getType(), Set.of());
            Map<String, String> encryptedProperties = Optional.ofNullable(extension.getProperties()).orElse(Map.of()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this.encryptPropertyIfNeeded(sensitivePropertyNames)));
            extension.setProperties(encryptedProperties);
        });
    }

    private Stream<? extends VersionedConfigurableExtension> fetchFlowComponents(VersionedDataflow flow) {
        return Stream.concat(Optional.ofNullable(flow.getControllerServices()).orElse(List.of()).stream(), this.fetchComponentsRecursively(flow.getRootGroup()));
    }

    private Stream<? extends VersionedConfigurableExtension> fetchComponentsRecursively(VersionedProcessGroup processGroup) {
        return Stream.concat(Stream.of(Optional.ofNullable(processGroup.getProcessors()).orElse(Set.of()), Optional.ofNullable(processGroup.getControllerServices()).orElse(Set.of())).flatMap(Collection::stream), Optional.ofNullable(processGroup.getProcessGroups()).orElse(Set.of()).stream().flatMap(this::fetchComponentsRecursively));
    }

    private Set<String> mergeSets(Set<String> first, Set<String> second) {
        first.addAll(second);
        return first;
    }

    private Function<Map.Entry<String, String>, String> encryptPropertyIfNeeded(Set<String> sensitivePropertyNames) {
        return entry -> sensitivePropertyNames.contains(entry.getKey()) && !((String)entry.getValue()).startsWith("enc{") ? this.encrypt((String)entry.getValue()) : (String)entry.getValue();
    }

    private String encrypt(String parameter) {
        return String.format(ENCRYPTED_FORMAT, this.propertyEncryptor.encrypt(parameter));
    }
}

