/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.apache.nifi.minifi.bootstrap.util.ProcessUtils;

public class CurrentPortProvider {
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final MiNiFiParameters miNiFiParameters;
    private final ProcessUtils processUtils;

    public CurrentPortProvider(MiNiFiCommandSender miNiFiCommandSender, MiNiFiParameters miNiFiParameters, ProcessUtils processUtils) {
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.miNiFiParameters = miNiFiParameters;
        this.processUtils = processUtils;
    }

    public Integer getCurrentPort() {
        int miNiFiPort = this.miNiFiParameters.getMiNiFiPort();
        if (miNiFiPort == -1) {
            RunMiNiFi.DEFAULT_LOGGER.debug("Port is not defined");
            return null;
        }
        RunMiNiFi.DEFAULT_LOGGER.debug("Current port: {}", (Object)miNiFiPort);
        boolean success = this.miNiFiCommandSender.isPingSuccessful(miNiFiPort);
        if (success) {
            RunMiNiFi.DEFAULT_LOGGER.debug("Successful PING on port {}", (Object)miNiFiPort);
            return miNiFiPort;
        }
        long minifiPid = this.miNiFiParameters.getMinifiPid();
        RunMiNiFi.DEFAULT_LOGGER.debug("Current PID {}", (Object)minifiPid);
        boolean procRunning = this.processUtils.isProcessRunning(minifiPid);
        if (procRunning) {
            return miNiFiPort;
        }
        return null;
    }
}

