/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.InputStream;
import java.util.Objects;
import org.apache.nifi.nar.NarSource;

public class NarInstallRequest {
    private final NarSource source;
    private final String sourceIdentifier;
    private final InputStream inputStream;

    private NarInstallRequest(Builder builder) {
        this.source = Objects.requireNonNull(builder.source);
        this.sourceIdentifier = Objects.requireNonNull(builder.sourceIdentifier);
        this.inputStream = Objects.requireNonNull(builder.inputStream);
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public NarSource getSource() {
        return this.source;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private NarSource source;
        private String sourceIdentifier;
        private InputStream inputStream;

        public Builder source(NarSource source) {
            this.source = source;
            return this;
        }

        public Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public NarInstallRequest build() {
            return new NarInstallRequest(this);
        }
    }
}

