/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nifi.processors.standard.property;

import org.apache.nifi.components.DescribedValue;

/**
 * Transmission Strategy enumeration of allowable values for component Property Descriptors
 */
public enum TransmissionStrategy implements DescribedValue {
    FLOWFILE_ORIENTED("FlowFile-oriented", "Send FlowFile content as a single stream"),

    RECORD_ORIENTED("Record-oriented", "Read Records from input FlowFiles and send serialized Records as individual messages");

    private final String displayName;

    private final String description;

    TransmissionStrategy(final String displayName, final String description) {
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getValue() {
        return name();
    }

    @Override
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
