/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.helpers.SessionHelper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class SessionTimeoutListener
extends AbstractLoggingBean
implements SessionListener,
Runnable {
    protected final Set<SessionHelper> sessions = new CopyOnWriteArraySet<SessionHelper>();

    @Override
    public void sessionCreated(Session session) {
        if (session instanceof SessionHelper && (GenericUtils.isPositive(session.getAuthTimeout()) || GenericUtils.isPositive(session.getIdleTimeout()))) {
            this.sessions.add((SessionHelper)session);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionCreated({}) tracking", (Object)session);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionCreated({}) not tracked", (Object)session);
        }
    }

    @Override
    public void sessionException(Session session, Throwable t) {
        this.debug("sessionException({}) {}: {}", session, t.getClass().getSimpleName(), t.getMessage(), t);
        this.sessionClosed(session);
    }

    @Override
    public void sessionClosed(Session s) {
        if (this.sessions.remove(s)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sessionClosed({}) un-tracked", (Object)s);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("sessionClosed({}) not tracked", (Object)s);
        }
    }

    @Override
    public void run() {
        for (SessionHelper session : this.sessions) {
            try {
                session.checkForTimeouts();
            }
            catch (Exception e) {
                this.warn("run({}) {} while checking timeouts: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
            }
        }
    }
}

