/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public final class CompositeAccessDeniedHandler
implements AccessDeniedHandler {
    private Collection<AccessDeniedHandler> handlers;

    public CompositeAccessDeniedHandler(AccessDeniedHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public CompositeAccessDeniedHandler(Collection<AccessDeniedHandler> handlers) {
        this.handlers = new ArrayList<AccessDeniedHandler>(handlers);
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        for (AccessDeniedHandler handler : this.handlers) {
            handler.handle(request, response, accessDeniedException);
        }
    }
}

