/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.processing.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.ProcessingFeature;
import org.apache.nifi.xml.processing.parsers.DocumentProvider;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class StandardDocumentProvider
implements DocumentProvider {
    private boolean namespaceAware;
    private Schema schema;
    private ErrorHandler errorHandler;

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Document newDocument() {
        DocumentBuilderFactory documentBuilderFactory = this.getDocumentBuilderFactory();
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", ProcessingFeature.SECURE_PROCESSING.isEnabled());
            documentBuilderFactory.setFeature(ProcessingFeature.DISALLOW_DOCTYPE_DECL.getFeature(), ProcessingFeature.DISALLOW_DOCTYPE_DECL.isEnabled());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this.errorHandler);
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException("Configuration failed", e);
        }
    }

    @Override
    public Document parse(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "InputStream required");
        DocumentBuilderFactory documentBuilderFactory = this.getDocumentBuilderFactory();
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", ProcessingFeature.SECURE_PROCESSING.isEnabled());
            documentBuilderFactory.setFeature(ProcessingFeature.DISALLOW_DOCTYPE_DECL.getFeature(), this.isDisallowDocumentTypeDeclaration());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(this.errorHandler);
            return documentBuilder.parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ProcessingException("Parsing failed", e);
        }
    }

    protected boolean isDisallowDocumentTypeDeclaration() {
        return ProcessingFeature.DISALLOW_DOCTYPE_DECL.isEnabled();
    }

    private DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setSchema(this.schema);
        documentBuilderFactory.setNamespaceAware(this.namespaceAware);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        return documentBuilderFactory;
    }
}

