/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authentication;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class AuthenticationResponse
implements Serializable {
    private final String identity;
    private final String username;
    private final long expiration;
    private final String issuer;
    private final Set<String> groups;

    public AuthenticationResponse(String identity, String username, long expiration, String issuer) {
        this(identity, username, expiration, issuer, Collections.emptySet());
    }

    public AuthenticationResponse(String identity, String username, long expiration, String issuer, Set<String> groups) {
        this.identity = identity;
        this.username = username;
        this.expiration = expiration;
        this.issuer = issuer;
        this.groups = groups;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getUsername() {
        return this.username;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationResponse that = (AuthenticationResponse)o;
        if (this.expiration != that.expiration) {
            return false;
        }
        if (this.identity != null ? !this.identity.equals(that.identity) : that.identity != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        return this.issuer != null ? this.issuer.equals(that.issuer) : that.issuer == null;
    }

    public int hashCode() {
        int result = this.identity != null ? this.identity.hashCode() : 0;
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (int)(this.expiration ^ this.expiration >>> 32);
        result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AuthenticationResponse{identity='" + this.identity + "', username='" + this.username + "', expiration=" + this.expiration + ", issuer='" + this.issuer + "'}";
    }
}

