/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

@FunctionalInterface
public interface WritableJson {
    public void to(Appendable var1) throws IOException;

    default public String toJsonString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            this.to(stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    default public byte[] toByteArray() {
        return this.toByteArray(StandardCharsets.UTF_8);
    }

    default public byte[] toByteArray(Charset charset) {
        byte[] byArray;
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.toWriter(new OutputStreamWriter((OutputStream)out, charset));
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        out.close();
        return byArray;
    }

    default public void toResource(WritableResource out) throws IOException {
        Assert.notNull((Object)out, (String)"'out' must not be null");
        try (OutputStream outputStream = out.getOutputStream();){
            this.toOutputStream(outputStream);
        }
    }

    default public void toResource(WritableResource out, Charset charset) throws IOException {
        Assert.notNull((Object)out, (String)"'out' must not be null");
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        try (OutputStream outputStream = out.getOutputStream();){
            this.toOutputStream(outputStream, charset);
        }
    }

    default public void toOutputStream(OutputStream out) throws IOException {
        this.toOutputStream(out, StandardCharsets.UTF_8);
    }

    default public void toOutputStream(OutputStream out, Charset charset) throws IOException {
        Assert.notNull((Object)out, (String)"'out' must not be null");
        Assert.notNull((Object)charset, (String)"'charset' must not be null");
        this.toWriter(new OutputStreamWriter(out, charset));
    }

    default public void toWriter(Writer out) throws IOException {
        Assert.notNull((Object)out, (String)"'out' must not be null");
        this.to(out);
        out.flush();
    }

    public static WritableJson of(final WritableJson writableJson) {
        return new WritableJson(){

            @Override
            public void to(Appendable out) throws IOException {
                writableJson.to(out);
            }

            public String toString() {
                return this.toJsonString();
            }
        };
    }
}

