/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;

@Plugin(name="enclosedInSquareBrackets", category="Converter")
@ConverterKeys(value={"esb"})
public final class EnclosedInSquareBracketsConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;

    private EnclosedInSquareBracketsConverter(List<PatternFormatter> formatters) {
        super("enclosedInSquareBrackets", null);
        this.formatters = formatters;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : this.formatters) {
            formatter.format(event, buf);
        }
        if (buf.isEmpty()) {
            return;
        }
        toAppendTo.append("[");
        toAppendTo.append((CharSequence)buf);
        toAppendTo.append("] ");
    }

    public static EnclosedInSquareBracketsConverter newInstance(Configuration config, String[] options) {
        if (options.length < 1) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received {}", (Object)options.length);
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[0]);
        return new EnclosedInSquareBracketsConverter(formatters);
    }
}

