/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import java.io.IOException;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.client.AccessClient;
import org.apache.nifi.registry.client.BucketClient;
import org.apache.nifi.registry.client.BundleClient;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.ExtensionClient;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.ItemsClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryClientConfig;
import org.apache.nifi.registry.client.PoliciesClient;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.TenantsClient;
import org.apache.nifi.registry.client.UserClient;
import org.apache.nifi.registry.client.impl.BucketItemDeserializer;
import org.apache.nifi.registry.client.impl.JerseyAccessClient;
import org.apache.nifi.registry.client.impl.JerseyBucketClient;
import org.apache.nifi.registry.client.impl.JerseyBundleClient;
import org.apache.nifi.registry.client.impl.JerseyBundleVersionClient;
import org.apache.nifi.registry.client.impl.JerseyExtensionClient;
import org.apache.nifi.registry.client.impl.JerseyExtensionRepoClient;
import org.apache.nifi.registry.client.impl.JerseyFlowClient;
import org.apache.nifi.registry.client.impl.JerseyFlowSnapshotClient;
import org.apache.nifi.registry.client.impl.JerseyItemsClient;
import org.apache.nifi.registry.client.impl.JerseyPoliciesClient;
import org.apache.nifi.registry.client.impl.JerseyTenantsClient;
import org.apache.nifi.registry.client.impl.JerseyUserClient;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class JerseyNiFiRegistryClient
implements NiFiRegistryClient {
    static final String NIFI_REGISTRY_CONTEXT = "nifi-registry-api";
    static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    static final int DEFAULT_READ_TIMEOUT = 10000;
    private final Client client;
    private final WebTarget baseTarget;
    private final BucketClient bucketClient;
    private final FlowClient flowClient;
    private final FlowSnapshotClient flowSnapshotClient;
    private final ItemsClient itemsClient;

    private JerseyNiFiRegistryClient(NiFiRegistryClient.Builder builder) {
        NiFiRegistryClientConfig registryClientConfig = builder.getConfig();
        if (registryClientConfig == null) {
            throw new IllegalArgumentException("NiFiRegistryClientConfig cannot be null");
        }
        Object baseUrl = registryClientConfig.getBaseUrl();
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new IllegalArgumentException("Base URL cannot be blank");
        }
        if (((String)baseUrl).endsWith("/")) {
            baseUrl = ((String)baseUrl).substring(0, ((String)baseUrl).length() - 1);
        }
        if (!((String)baseUrl).endsWith(NIFI_REGISTRY_CONTEXT)) {
            baseUrl = (String)baseUrl + "/nifi-registry-api";
        }
        try {
            new URI((String)baseUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid base URL: " + e.getMessage(), e);
        }
        SSLContext sslContext = registryClientConfig.getSslContext();
        HostnameVerifier hostnameVerifier = registryClientConfig.getHostnameVerifier();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            clientBuilder.hostnameVerifier(hostnameVerifier);
        }
        int connectTimeout = registryClientConfig.getConnectTimeout() == null ? 10000 : registryClientConfig.getConnectTimeout();
        int readTimeout = registryClientConfig.getReadTimeout() == null ? 10000 : registryClientConfig.getReadTimeout();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
        clientConfig.property("jersey.config.client.readTimeout", (Object)readTimeout);
        clientConfig.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.CHUNKED);
        clientConfig.register((Object)JerseyNiFiRegistryClient.jacksonJaxbJsonProvider());
        clientBuilder.withConfig((Configuration)clientConfig);
        this.client = ((ClientBuilder)clientBuilder.register(MultiPartFeature.class)).build();
        this.baseTarget = this.client.target((String)baseUrl);
        this.bucketClient = new JerseyBucketClient(this.baseTarget);
        this.flowClient = new JerseyFlowClient(this.baseTarget);
        this.flowSnapshotClient = new JerseyFlowSnapshotClient(this.baseTarget);
        this.itemsClient = new JerseyItemsClient(this.baseTarget);
    }

    @Override
    public BucketClient getBucketClient() {
        return this.bucketClient;
    }

    @Override
    public BucketClient getBucketClient(RequestConfig requestConfig) {
        return new JerseyBucketClient(this.baseTarget, requestConfig);
    }

    @Override
    public FlowClient getFlowClient() {
        return this.flowClient;
    }

    @Override
    public FlowClient getFlowClient(RequestConfig requestConfig) {
        return new JerseyFlowClient(this.baseTarget, requestConfig);
    }

    @Override
    public FlowSnapshotClient getFlowSnapshotClient() {
        return this.flowSnapshotClient;
    }

    @Override
    public FlowSnapshotClient getFlowSnapshotClient(RequestConfig requestConfig) {
        return new JerseyFlowSnapshotClient(this.baseTarget, requestConfig);
    }

    @Override
    public ItemsClient getItemsClient() {
        return this.itemsClient;
    }

    @Override
    public ItemsClient getItemsClient(RequestConfig requestConfig) {
        return new JerseyItemsClient(this.baseTarget, requestConfig);
    }

    @Override
    public UserClient getUserClient() {
        return new JerseyUserClient(this.baseTarget);
    }

    @Override
    public UserClient getUserClient(RequestConfig requestConfig) {
        return new JerseyUserClient(this.baseTarget, requestConfig);
    }

    @Override
    public BundleClient getBundleClient() {
        return new JerseyBundleClient(this.baseTarget);
    }

    @Override
    public BundleClient getBundleClient(RequestConfig requestConfig) {
        return new JerseyBundleClient(this.baseTarget, requestConfig);
    }

    @Override
    public BundleVersionClient getBundleVersionClient() {
        return new JerseyBundleVersionClient(this.baseTarget);
    }

    @Override
    public BundleVersionClient getBundleVersionClient(RequestConfig requestConfig) {
        return new JerseyBundleVersionClient(this.baseTarget, requestConfig);
    }

    @Override
    public ExtensionRepoClient getExtensionRepoClient() {
        return new JerseyExtensionRepoClient(this.baseTarget);
    }

    @Override
    public ExtensionRepoClient getExtensionRepoClient(RequestConfig requestConfig) {
        return new JerseyExtensionRepoClient(this.baseTarget, requestConfig);
    }

    @Override
    public ExtensionClient getExtensionClient() {
        return new JerseyExtensionClient(this.baseTarget);
    }

    @Override
    public ExtensionClient getExtensionClient(RequestConfig requestConfig) {
        return new JerseyExtensionClient(this.baseTarget, requestConfig);
    }

    @Override
    public TenantsClient getTenantsClient() {
        return new JerseyTenantsClient(this.baseTarget);
    }

    @Override
    public TenantsClient getTenantsClient(RequestConfig requestConfig) {
        return new JerseyTenantsClient(this.baseTarget, requestConfig);
    }

    @Override
    public PoliciesClient getPoliciesClient() {
        return new JerseyPoliciesClient(this.baseTarget);
    }

    @Override
    public PoliciesClient getPoliciesClient(RequestConfig requestConfig) {
        return new JerseyPoliciesClient(this.baseTarget, requestConfig);
    }

    @Override
    public AccessClient getAccessClient() {
        return new JerseyAccessClient(this.baseTarget);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static JacksonJaxbJsonProvider jacksonJaxbJsonProvider() {
        JacksonJaxbJsonProvider jacksonJaxbJsonProvider = new JacksonJaxbJsonProvider();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(mapper.getTypeFactory()));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(BucketItem[].class, (JsonDeserializer)new BucketItemDeserializer());
        mapper.registerModule((Module)module);
        jacksonJaxbJsonProvider.setMapper(mapper);
        return jacksonJaxbJsonProvider;
    }

    public static class Builder
    implements NiFiRegistryClient.Builder {
        private NiFiRegistryClientConfig clientConfig;

        @Override
        public Builder config(NiFiRegistryClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @Override
        public NiFiRegistryClientConfig getConfig() {
            return this.clientConfig;
        }

        @Override
        public NiFiRegistryClient build() {
            return new JerseyNiFiRegistryClient(this);
        }
    }
}

