/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.krb;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.lang3.Validate;

public class UsernamePasswordCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;

    public UsernamePasswordCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
        Validate.notBlank((CharSequence)this.username);
        Validate.notBlank((CharSequence)this.password);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            throw new IllegalStateException("Unexpected callback type: " + callback.getClass().getCanonicalName());
        }
    }
}

