/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.util.NumberUtil;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.Permissible;

@XmlRootElement(name="processGroupEntity")
public class ProcessGroupEntity
extends ComponentEntity
implements Permissible<ProcessGroupDTO> {
    private ProcessGroupDTO component;
    private ProcessGroupStatusDTO status;
    private RegisteredFlowSnapshot versionedFlowSnapshot;
    private Integer runningCount;
    private Integer stoppedCount;
    private Integer invalidCount;
    private Integer disabledCount;
    private Integer activeRemotePortCount;
    private Integer inactiveRemotePortCount;
    private String versionedFlowState;
    private Integer upToDateCount;
    private Integer locallyModifiedCount;
    private Integer staleCount;
    private Integer locallyModifiedAndStaleCount;
    private Integer syncFailureCount;
    private Integer localInputPortCount;
    private Integer localOutputPortCount;
    private Integer publicInputPortCount;
    private Integer publicOutputPortCount;
    private ParameterContextReferenceEntity parameterContext;
    private String processGroupUpdateStrategy;

    @Override
    public ProcessGroupDTO getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(ProcessGroupDTO component) {
        this.component = component;
    }

    @Schema(description="The status of the process group.")
    public ProcessGroupStatusDTO getStatus() {
        return this.status;
    }

    public void setStatus(ProcessGroupStatusDTO status) {
        this.status = status;
    }

    @Schema(description="The number of input ports in the process group.", accessMode=Schema.AccessMode.READ_ONLY)
    public Integer getInputPortCount() {
        return NumberUtil.sumNullableIntegers(this.localInputPortCount, this.publicInputPortCount);
    }

    public void setInputPortCount(Integer inputPortCount) {
    }

    @Schema(description="The number of local input ports in the process group.")
    public Integer getLocalInputPortCount() {
        return this.localInputPortCount;
    }

    public void setLocalInputPortCount(Integer localInputPortCount) {
        this.localInputPortCount = localInputPortCount;
    }

    @Schema(description="The number of public input ports in the process group.")
    public Integer getPublicInputPortCount() {
        return this.publicInputPortCount;
    }

    public void setPublicInputPortCount(Integer publicInputPortCount) {
        this.publicInputPortCount = publicInputPortCount;
    }

    @Schema(description="The number of invalid components in the process group.")
    public Integer getInvalidCount() {
        return this.invalidCount;
    }

    public void setInvalidCount(Integer invalidCount) {
        this.invalidCount = invalidCount;
    }

    @Schema(description="The number of output ports in the process group.", accessMode=Schema.AccessMode.READ_ONLY)
    public Integer getOutputPortCount() {
        return NumberUtil.sumNullableIntegers(this.localOutputPortCount, this.publicOutputPortCount);
    }

    public void setOutputPortCount(Integer outputPortCount) {
    }

    @Schema(description="The number of local output ports in the process group.")
    public Integer getLocalOutputPortCount() {
        return this.localOutputPortCount;
    }

    public void setLocalOutputPortCount(Integer localOutputPortCount) {
        this.localOutputPortCount = localOutputPortCount;
    }

    @Schema(description="The number of public output ports in the process group.")
    public Integer getPublicOutputPortCount() {
        return this.publicOutputPortCount;
    }

    public void setPublicOutputPortCount(Integer publicOutputPortCount) {
        this.publicOutputPortCount = publicOutputPortCount;
    }

    @Schema(description="The number of running components in this process group.")
    public Integer getRunningCount() {
        return this.runningCount;
    }

    public void setRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
    }

    @Schema(description="The number of stopped components in the process group.")
    public Integer getStoppedCount() {
        return this.stoppedCount;
    }

    public void setStoppedCount(Integer stoppedCount) {
        this.stoppedCount = stoppedCount;
    }

    @Schema(description="The number of disabled components in the process group.")
    public Integer getDisabledCount() {
        return this.disabledCount;
    }

    public void setDisabledCount(Integer disabledCount) {
        this.disabledCount = disabledCount;
    }

    @Schema(description="The number of active remote ports in the process group.")
    public Integer getActiveRemotePortCount() {
        return this.activeRemotePortCount;
    }

    public void setActiveRemotePortCount(Integer activeRemotePortCount) {
        this.activeRemotePortCount = activeRemotePortCount;
    }

    @Schema(description="The number of inactive remote ports in the process group.")
    public Integer getInactiveRemotePortCount() {
        return this.inactiveRemotePortCount;
    }

    public void setInactiveRemotePortCount(Integer inactiveRemotePortCount) {
        this.inactiveRemotePortCount = inactiveRemotePortCount;
    }

    @Schema(description="Returns the Versioned Flow that describes the contents of the Versioned Flow to be imported", accessMode=Schema.AccessMode.READ_ONLY)
    public RegisteredFlowSnapshot getVersionedFlowSnapshot() {
        return this.versionedFlowSnapshot;
    }

    public void setVersionedFlowSnapshot(RegisteredFlowSnapshot versionedFlowSnapshot) {
        this.versionedFlowSnapshot = versionedFlowSnapshot;
    }

    @Schema(description="The current state of the Process Group, as it relates to the Versioned Flow", allowableValues={"LOCALLY_MODIFIED", "STALE", "LOCALLY_MODIFIED_AND_STALE", "UP_TO_DATE", "SYNC_FAILURE"}, accessMode=Schema.AccessMode.READ_ONLY)
    public String getVersionedFlowState() {
        return this.versionedFlowState;
    }

    public void setVersionedFlowState(String versionedFlowState) {
        this.versionedFlowState = versionedFlowState;
    }

    @Schema(description="The number of up to date versioned process groups in the process group.")
    public Integer getUpToDateCount() {
        return this.upToDateCount;
    }

    public void setUpToDateCount(Integer upToDateCount) {
        this.upToDateCount = upToDateCount;
    }

    @Schema(description="The number of locally modified versioned process groups in the process group.")
    public Integer getLocallyModifiedCount() {
        return this.locallyModifiedCount;
    }

    public void setLocallyModifiedCount(Integer locallyModifiedCount) {
        this.locallyModifiedCount = locallyModifiedCount;
    }

    @Schema(description="The number of stale versioned process groups in the process group.")
    public Integer getStaleCount() {
        return this.staleCount;
    }

    public void setStaleCount(Integer staleCount) {
        this.staleCount = staleCount;
    }

    @Schema(description="The number of locally modified and stale versioned process groups in the process group.")
    public Integer getLocallyModifiedAndStaleCount() {
        return this.locallyModifiedAndStaleCount;
    }

    public void setLocallyModifiedAndStaleCount(Integer locallyModifiedAndStaleCount) {
        this.locallyModifiedAndStaleCount = locallyModifiedAndStaleCount;
    }

    @Schema(description="The number of versioned process groups in the process group that are unable to sync to a registry.")
    public Integer getSyncFailureCount() {
        return this.syncFailureCount;
    }

    public void setSyncFailureCount(Integer syncFailureCount) {
        this.syncFailureCount = syncFailureCount;
    }

    @Schema(description="The Parameter Context, or null if no Parameter Context has been bound to the Process Group")
    public ParameterContextReferenceEntity getParameterContext() {
        return this.parameterContext;
    }

    public void setParameterContext(ParameterContextReferenceEntity parameterContext) {
        this.parameterContext = parameterContext;
    }

    @Schema(description="Determines the process group update strategy", allowableValues={"CURRENT_GROUP", "CURRENT_GROUP_WITH_CHILDREN"})
    public String getProcessGroupUpdateStrategy() {
        return this.processGroupUpdateStrategy;
    }

    public void setProcessGroupUpdateStrategy(String processGroupUpdateStrategy) {
        this.processGroupUpdateStrategy = processGroupUpdateStrategy;
    }
}

