/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.InputStreamKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardPemCertificateReader;

public class PemCertificateKeyStoreBuilder
implements InputStreamKeyStoreBuilder {
    private static final String CERTIFICATE_ALIAS = "certificate-%d";
    private InputStream inputStream;

    @Override
    public KeyStore build() {
        KeyStore keyStore = this.getInitializedKeyStore();
        if (this.inputStream == null) {
            throw new BuilderConfigurationException("Key Store InputStream not configured");
        }
        this.loadKeyStore(keyStore);
        return keyStore;
    }

    @Override
    public PemCertificateKeyStoreBuilder inputStream(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream, "Key Store InputStream required");
        return this;
    }

    private void loadKeyStore(KeyStore keyStore) {
        StandardPemCertificateReader pemCertificateReader = new StandardPemCertificateReader();
        List<Certificate> certificates = pemCertificateReader.readCertificates(this.inputStream);
        int certificateIndex = 0;
        for (Certificate certificate : certificates) {
            String alias = CERTIFICATE_ALIAS.formatted(certificateIndex++);
            try {
                keyStore.setCertificateEntry(alias, certificate);
            }
            catch (KeyStoreException e) {
                String message = String.format("Set certificate entry [%s] failed", alias);
                throw new BuilderConfigurationException(message, e);
            }
        }
    }

    private KeyStore getInitializedKeyStore() {
        String keyStoreType = KeyStore.getDefaultType();
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null);
            return keyStore;
        }
        catch (Exception e) {
            String message = String.format("Key Store Type [%s] initialization failed", keyStoreType);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

