/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl.request.util;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class AccessToken {
    private String accessToken;
    private String refreshToken;
    private String tokenType;
    private long expiresIn;
    private String scope;
    private final Instant fetchTime;
    private final Map<String, Object> additionalParameters = new HashMap<String, Object>();

    public AccessToken() {
        this.fetchTime = Instant.now();
    }

    public AccessToken(String accessToken, String refreshToken, String tokenType, long expiresIn, String scope) {
        this();
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        this.scope = scope;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Instant getFetchTime() {
        return this.fetchTime;
    }

    public boolean isExpired() {
        Instant expirationTime = this.fetchTime.plusSeconds(this.expiresIn);
        return this.now().isAfter(expirationTime);
    }

    Instant now() {
        return Instant.now();
    }

    public void setAdditionalParameter(String key, Object value) {
        this.additionalParameters.put(key, value);
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }
}

