/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;

public class CreateRegistryClient
extends AbstractNiFiCommand<StringResult> {
    public CreateRegistryClient() {
        super("create-reg-client", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a registry client using the provided information.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.REGISTRY_CLIENT_NAME.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_DESC.createOption());
        this.addOption(CommandOption.REGISTRY_CLIENT_TYPE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String name = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_NAME);
        String type = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_TYPE);
        String desc = this.getArg(properties, CommandOption.REGISTRY_CLIENT_DESC);
        FlowRegistryClientDTO flowRegistryClientDTO = new FlowRegistryClientDTO();
        flowRegistryClientDTO.setName(name);
        flowRegistryClientDTO.setDescription(desc);
        flowRegistryClientDTO.setType(type);
        FlowRegistryClientEntity clientEntity = new FlowRegistryClientEntity();
        clientEntity.setComponent(flowRegistryClientDTO);
        clientEntity.setRevision(this.getInitialRevisionDTO());
        FlowRegistryClientEntity createdEntity = client.getControllerClient().createRegistryClient(clientEntity);
        return new StringResult(createdEntity.getId(), this.getContext().isInteractive());
    }
}

