/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataEntity;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;

public class VersionedFlowSnapshotMetadataSetResult
extends AbstractWritableResult<VersionedFlowSnapshotMetadataSetEntity> {
    private final VersionedFlowSnapshotMetadataSetEntity versionedFlowSnapshotMetadataSetEntity;

    public VersionedFlowSnapshotMetadataSetResult(ResultType resultType, VersionedFlowSnapshotMetadataSetEntity versionedFlowSnapshotMetadataSetEntity) {
        super(resultType);
        this.versionedFlowSnapshotMetadataSetEntity = Objects.requireNonNull(versionedFlowSnapshotMetadataSetEntity);
    }

    @Override
    public VersionedFlowSnapshotMetadataSetEntity getResult() {
        return this.versionedFlowSnapshotMetadataSetEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set entities = this.versionedFlowSnapshotMetadataSetEntity.getVersionedFlowSnapshotMetadataSet();
        if (entities == null || entities.isEmpty()) {
            return;
        }
        List<RegisteredFlowSnapshotMetadata> snapshots = entities.stream().map(VersionedFlowSnapshotMetadataEntity::getVersionedFlowSnapshotMetadata).sorted(Comparator.comparing(RegisteredFlowSnapshotMetadata::getTimestamp)).toList();
        String datePattern = "%1$ta, %<tb %<td %<tY %<tR %<tZ";
        int dateLength = String.format("%1$ta, %<tb %<td %<tY %<tR %<tZ", new Date()).length();
        Table table = new Table.Builder().column("Ver", 3, 3, false).column("Date", dateLength, dateLength, false).column("Author", 20, 200, true).column("Message", 8, 40, true).build();
        snapshots.forEach(vfs -> table.addRow(vfs.getVersion(), String.format("%1$ta, %<tb %<td %<tY %<tR %<tZ", new Date(vfs.getTimestamp())), vfs.getAuthor() == null ? "" : vfs.getAuthor(), vfs.getComments() == null ? "" : vfs.getComments()));
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

