/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import java.util.UUID;
import java.util.function.Consumer;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.DefaultCsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class CookieServerCsrfTokenRepository
implements ServerCsrfTokenRepository {
    static final String DEFAULT_CSRF_COOKIE_NAME = "XSRF-TOKEN";
    static final String DEFAULT_CSRF_PARAMETER_NAME = "_csrf";
    static final String DEFAULT_CSRF_HEADER_NAME = "X-XSRF-TOKEN";
    private String parameterName = "_csrf";
    private String headerName = "X-XSRF-TOKEN";
    private String cookiePath;
    private String cookieDomain;
    private String cookieName = "XSRF-TOKEN";
    private boolean cookieHttpOnly = true;
    private Boolean secure;
    private int cookieMaxAge = -1;
    private Consumer<ResponseCookie.ResponseCookieBuilder> cookieCustomizer = builder -> {};

    public void setCookieCustomizer(Consumer<ResponseCookie.ResponseCookieBuilder> cookieCustomizer) {
        Assert.notNull(cookieCustomizer, (String)"cookieCustomizer must not be null");
        this.cookieCustomizer = cookieCustomizer;
    }

    public static CookieServerCsrfTokenRepository withHttpOnlyFalse() {
        CookieServerCsrfTokenRepository result = new CookieServerCsrfTokenRepository();
        result.cookieHttpOnly = false;
        return result;
    }

    @Override
    public Mono<CsrfToken> generateToken(ServerWebExchange exchange) {
        return Mono.fromCallable(this::createCsrfToken).subscribeOn(Schedulers.boundedElastic());
    }

    @Override
    public Mono<Void> saveToken(ServerWebExchange exchange, CsrfToken token) {
        return Mono.fromRunnable(() -> {
            String tokenValue = token != null ? token.getToken() : "";
            ResponseCookie.ResponseCookieBuilder cookieBuilder = ResponseCookie.from((String)this.cookieName, (String)tokenValue).domain(this.cookieDomain).httpOnly(this.cookieHttpOnly).maxAge(!tokenValue.isEmpty() ? (long)this.cookieMaxAge : 0L).path(this.cookiePath != null ? this.cookiePath : this.getRequestContext(exchange.getRequest())).secure(this.secure != null ? this.secure : exchange.getRequest().getSslInfo() != null);
            this.cookieCustomizer.accept(cookieBuilder);
            exchange.getResponse().addCookie(cookieBuilder.build());
        });
    }

    @Override
    public Mono<CsrfToken> loadToken(ServerWebExchange exchange) {
        return Mono.fromCallable(() -> {
            HttpCookie csrfCookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)this.cookieName);
            if (csrfCookie == null || !StringUtils.hasText((String)csrfCookie.getValue())) {
                return null;
            }
            return this.createCsrfToken(csrfCookie.getValue());
        });
    }

    @Deprecated(since="6.1")
    public void setCookieHttpOnly(boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieName(String cookieName) {
        Assert.hasLength((String)cookieName, (String)"cookieName can't be null");
        this.cookieName = cookieName;
    }

    public void setParameterName(String parameterName) {
        Assert.hasLength((String)parameterName, (String)"parameterName can't be null");
        this.parameterName = parameterName;
    }

    public void setHeaderName(String headerName) {
        Assert.hasLength((String)headerName, (String)"headerName can't be null");
        this.headerName = headerName;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    @Deprecated(since="6.1")
    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    @Deprecated(since="6.1")
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Deprecated(since="6.1")
    public void setCookieMaxAge(int cookieMaxAge) {
        Assert.isTrue((cookieMaxAge != 0 ? 1 : 0) != 0, (String)"cookieMaxAge cannot be zero");
        this.cookieMaxAge = cookieMaxAge;
    }

    private CsrfToken createCsrfToken() {
        return this.createCsrfToken(this.createNewToken());
    }

    private CsrfToken createCsrfToken(String tokenValue) {
        return new DefaultCsrfToken(this.headerName, this.parameterName, tokenValue);
    }

    private String createNewToken() {
        return UUID.randomUUID().toString();
    }

    private String getRequestContext(ServerHttpRequest request) {
        String contextPath = request.getPath().contextPath().value();
        return StringUtils.hasLength((String)contextPath) ? contextPath : "/";
    }
}

