/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.ManagementRequest;
import org.apache.qpid.server.management.plugin.ManagementResponse;
import org.apache.qpid.server.management.plugin.RequestType;
import org.apache.qpid.server.management.plugin.controller.AbstractManagementController;
import org.apache.qpid.server.management.plugin.controller.CategoryController;
import org.apache.qpid.server.management.plugin.controller.CategoryControllerFactory;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObjectToMapConverter;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.TypeControllerFactory;
import org.apache.qpid.server.model.ConfiguredObject;

public abstract class AbstractLegacyConfiguredObjectController
extends AbstractManagementController
implements LegacyManagementController {
    private final ManagementController _nextVersionManagementController;
    private final String _modelVersion;
    private final Map<String, String> _categoryNames = new HashMap<String, String>();
    private final Map<String, List<String>> _parents = new HashMap<String, List<String>>();
    private final Map<String, List<String>> _children = new HashMap<String, List<String>>();
    private final Map<String, CategoryController> _categoryConverters = new HashMap<String, CategoryController>();
    private final Map<String, Set<TypeController>> _typeControllers = new HashMap<String, Set<TypeController>>();
    private volatile LegacyConfiguredObjectToMapConverter _legacyConfiguredObjectToMapConverter;

    public AbstractLegacyConfiguredObjectController(String modelVersion, ManagementController nextVersionManagementController) {
        this._modelVersion = modelVersion;
        this._nextVersionManagementController = nextVersionManagementController;
    }

    @Override
    public String getVersion() {
        return this._modelVersion;
    }

    @Override
    public Collection<String> getCategories() {
        return Collections.unmodifiableCollection(this._categoryNames.values());
    }

    @Override
    public String getCategoryMapping(String category) {
        return String.format("/api/v%s/%s/", this.getVersion(), category.toLowerCase());
    }

    @Override
    public String getCategory(ConfiguredObject<?> managedObject) {
        return this._nextVersionManagementController.getCategory(managedObject);
    }

    public List<String> getCategoryHierarchy(ConfiguredObject<?> root, String categoryName) {
        return this.getCategoryHierarchy(this.getCategory(root), categoryName);
    }

    @Override
    public ManagementController getNextVersionManagementController() {
        return this._nextVersionManagementController;
    }

    @Override
    public LegacyConfiguredObject createOrUpdate(ConfiguredObject<?> root, String category, List<String> path, Map<String, Object> attributes, boolean isPost) throws ManagementException {
        return this.getCategoryController(category).createOrUpdate(root, path, attributes, isPost);
    }

    @Override
    public Object get(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this.getCategoryController(category).get(root, path, this.convertQueryParameters(parameters));
    }

    @Override
    public int delete(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this.getCategoryController(category).delete(root, path, this.convertQueryParameters(parameters));
    }

    @Override
    public ManagementResponse invoke(ConfiguredObject<?> root, String category, List<String> path, String operation, Map<String, Object> parameters, boolean isPost, boolean isSecureOrAllowedOnInsecureChannel) throws ManagementException {
        return this.getCategoryController(category).invoke(root, path, operation, parameters, isPost, isSecureOrAllowedOnInsecureChannel);
    }

    @Override
    public Object getPreferences(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this.getCategoryController(category).getPreferences(root, path, this.convertQueryParameters(parameters));
    }

    @Override
    public void setPreferences(ConfiguredObject<?> root, String category, List<String> path, Object preferences, Map<String, List<String>> parameters, boolean isPost) throws ManagementException {
        this.getCategoryController(category).setPreferences(root, path, preferences, parameters, isPost);
    }

    @Override
    public int deletePreferences(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        return this.getCategoryController(category).deletePreferences(root, path, this.convertQueryParameters(parameters));
    }

    @Override
    public CategoryController getCategoryController(String category) {
        CategoryController converter = this._categoryConverters.get(category.toLowerCase());
        if (converter == null) {
            throw ManagementException.createInternalServerErrorManagementException(String.format("Converter for type '%s' cannot be found ", category));
        }
        return converter;
    }

    @Override
    public Set<TypeController> getTypeControllersByCategory(String name) {
        Set<TypeController> typeControllers = this._typeControllers.get(name.toLowerCase());
        if (typeControllers == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(typeControllers);
    }

    public List<String> getCategoryHierarchy(String rootCategory, String categoryName) {
        if (!this._categoryNames.containsKey(rootCategory.toLowerCase())) {
            throw ManagementException.createInternalServerErrorManagementException(String.format("Unsupported root category '%s'", rootCategory));
        }
        if (!this._categoryNames.containsKey(categoryName.toLowerCase())) {
            throw ManagementException.createInternalServerErrorManagementException(String.format("Unsupported category '%s'", categoryName));
        }
        ArrayList<String> hierarchyList = new ArrayList<String>();
        String category = this._categoryNames.get(categoryName.toLowerCase());
        if (!category.equals(rootCategory)) {
            Collection parentCategories;
            hierarchyList.add(category);
            while (!(parentCategories = (Collection)this._parents.get(category)).contains(rootCategory)) {
                hierarchyList.addAll(parentCategories);
                category = (String)parentCategories.iterator().next();
            }
            Collections.reverse(hierarchyList);
        }
        return Collections.unmodifiableList(hierarchyList);
    }

    @Override
    public Collection<String> getChildrenCategories(String category) {
        List<String> children = this._children.get(this._categoryNames.get(category.toLowerCase()));
        if (children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(children);
    }

    @Override
    public Collection<String> getParentTypes(String category) {
        return this._parents.get(category);
    }

    public void initialize() {
        this.initialize(CategoryControllerFactory.findFactories(this.getVersion()), TypeControllerFactory.findFactories(this.getVersion()));
    }

    protected void initialize(Set<CategoryControllerFactory> categoryFactories, Set<TypeControllerFactory> typeFactories) {
        this.createTypeControllers(typeFactories);
        this.createCategoryControllers(categoryFactories);
        this._legacyConfiguredObjectToMapConverter = new LegacyConfiguredObjectToMapConverter(this);
    }

    @Override
    protected RequestType getRequestType(ManagementRequest managementRequest) throws ManagementException {
        List<String> path = managementRequest.getPath();
        String category = managementRequest.getCategory();
        if (category == null) {
            throw ManagementException.createNotFoundManagementException(String.format("Category is not found for path '%s%s'", this.getCategoryMapping(category), this.buildPath(path)));
        }
        Collection hierarchy = this.getCategoryHierarchy((ConfiguredObject)managementRequest.getRoot(), category);
        return this.getManagementRequestType(managementRequest.getMethod(), category, path, (List<String>)hierarchy);
    }

    @Override
    public LegacyConfiguredObject convertFromNextVersion(LegacyConfiguredObject nextVersionObject) {
        return this.getCategoryController(nextVersionObject.getCategory()).convertFromNextVersion(nextVersionObject);
    }

    protected abstract Map<String, List<String>> convertQueryParameters(Map<String, List<String>> var1);

    private void addRelationship(String parentCategory, String childCategory) {
        Collection parents = this._parents.computeIfAbsent(childCategory, k -> new ArrayList());
        parents.add(parentCategory);
        Collection children = this._children.computeIfAbsent(parentCategory, k -> new ArrayList());
        children.add(childCategory);
        this._categoryNames.put(childCategory.toLowerCase(), childCategory);
    }

    private void createCategoryControllers(Set<CategoryControllerFactory> factories) {
        factories.stream().map(this::create).flatMap(Collection::stream).peek(this::register).forEach(c -> {
            if (this._categoryConverters.put(c.getCategory().toLowerCase(), (CategoryController)c) != null) {
                throw new IllegalStateException(String.format("Category converter for category '%s' is already registered", c.getCategory()));
            }
        });
    }

    private Set<CategoryController> create(CategoryControllerFactory factory) {
        return factory.getSupportedCategories().stream().map(type -> factory.createController((String)type, this)).collect(Collectors.toSet());
    }

    private void register(CategoryController converter) {
        String type = converter.getCategory();
        for (String category : converter.getParentCategories()) {
            this.addRelationship(category, type);
        }
        this._categoryNames.put(type.toLowerCase(), type);
    }

    private void createTypeControllers(Set<TypeControllerFactory> typeFactories) {
        for (TypeControllerFactory factory : typeFactories) {
            TypeController controller = factory.createController(this);
            Set categoryTypeConverters = this._typeControllers.computeIfAbsent(factory.getCategory().toLowerCase(), k -> new HashSet());
            categoryTypeConverters.add(controller);
        }
    }

    protected LegacyConfiguredObjectToMapConverter getLegacyConfiguredObjectToMapConverter() {
        return this._legacyConfiguredObjectToMapConverter;
    }

    private RequestType getManagementRequestType(String method, String category, List<String> parts, List<String> hierarchy) {
        if ("POST".equals(method)) {
            return this.getPostRequestType(category, parts, hierarchy);
        }
        if ("PUT".equals(method)) {
            return this.getPutRequestType(category, parts, hierarchy);
        }
        if ("GET".equals(method)) {
            return this.getGetRequestType(category, parts, hierarchy);
        }
        if ("DELETE".equals(method)) {
            return this.getDeleteRequestType(category, parts, hierarchy);
        }
        throw ManagementException.createBadRequestManagementException(String.format("Unexpected method type '%s' for path '%s%s'", method, this.getCategoryMapping(category), this.buildPath(parts)));
    }

    private RequestType getDeleteRequestType(String category, List<String> parts, List<String> hierarchy) {
        if (parts.size() <= hierarchy.size()) {
            return RequestType.MODEL_OBJECT;
        }
        if ("userpreferences".equals(parts.get(hierarchy.size()))) {
            return RequestType.USER_PREFERENCES;
        }
        String categoryMapping = this.getCategoryMapping(category);
        String expectedPath = this.buildExpectedPath(categoryMapping, hierarchy);
        throw ManagementException.createBadRequestManagementException(String.format("Invalid DELETE path '%s%s'. Expected: '%s' or '%s/userpreferences[/<preference type>[/<preference name>]]'", categoryMapping, this.buildPath(parts), expectedPath, expectedPath));
    }

    private RequestType getGetRequestType(String category, List<String> parts, List<String> hierarchy) {
        if (parts.size() <= hierarchy.size()) {
            return RequestType.MODEL_OBJECT;
        }
        if ("userpreferences".equals(parts.get(hierarchy.size()))) {
            return RequestType.USER_PREFERENCES;
        }
        if ("visiblepreferences".equals(parts.get(hierarchy.size()))) {
            return RequestType.VISIBLE_PREFERENCES;
        }
        if (parts.size() == hierarchy.size() + 1) {
            return RequestType.OPERATION;
        }
        String categoryMapping = this.getCategoryMapping(category);
        throw ManagementException.createBadRequestManagementException(String.format("Invalid GET path '%s%s'. Expected: '%s[/<operation name>]'", categoryMapping, this.buildPath(parts), this.buildExpectedPath(categoryMapping, hierarchy)));
    }

    private RequestType getPutRequestType(String category, List<String> parts, List<String> hierarchy) {
        if (parts.size() == hierarchy.size() || parts.size() == hierarchy.size() - 1) {
            return RequestType.MODEL_OBJECT;
        }
        if (parts.size() > hierarchy.size() && "userpreferences".equals(parts.get(hierarchy.size()))) {
            return RequestType.USER_PREFERENCES;
        }
        String categoryMapping = this.getCategoryMapping(category);
        throw ManagementException.createBadRequestManagementException(String.format("Invalid PUT path '%s%s'. Expected: '%s'", categoryMapping, this.buildPath(parts), this.buildExpectedPath(categoryMapping, hierarchy)));
    }

    private RequestType getPostRequestType(String category, List<String> parts, List<String> hierarchy) {
        if (parts.size() == hierarchy.size() || parts.size() == hierarchy.size() - 1) {
            return RequestType.MODEL_OBJECT;
        }
        if (parts.size() > hierarchy.size()) {
            if ("userpreferences".equals(parts.get(hierarchy.size()))) {
                return RequestType.USER_PREFERENCES;
            }
            if (parts.size() == hierarchy.size() + 1 && !"visiblepreferences".equals(parts.get(hierarchy.size()))) {
                return RequestType.OPERATION;
            }
        }
        String categoryMapping = this.getCategoryMapping(category);
        String expectedFullPath = this.buildExpectedPath(categoryMapping, hierarchy);
        String expectedParentPath = this.buildExpectedPath(categoryMapping, hierarchy.subList(0, hierarchy.size() - 1));
        throw ManagementException.createBadRequestManagementException(String.format("Invalid POST path '%s%s'. Expected: '%s/<operation name>' or '%s' or '%s/userpreferences[/<preference type>]'", categoryMapping, this.buildPath(parts), expectedFullPath, expectedParentPath, expectedFullPath));
    }

    private String buildExpectedPath(String servletPath, List<String> hierarchy) {
        return hierarchy.stream().map(h -> String.format("/<%s name>", h)).collect(Collectors.joining("", servletPath, ""));
    }

    private String buildPath(List<String> path) {
        return path.isEmpty() ? "" : "/" + String.join((CharSequence)"/", path);
    }

    protected Object formatConfiguredObject(Object content, boolean isSecureOrAllowedOnInsecureChannel, int depth, int oversizeThreshold, boolean actuals, boolean excludeInheritedContext, boolean responseAsList) {
        if (content instanceof LegacyConfiguredObject) {
            Map<String, Object> object = this.convertObject((LegacyConfiguredObject)content, depth, actuals, oversizeThreshold, isSecureOrAllowedOnInsecureChannel, excludeInheritedContext);
            return responseAsList ? Collections.singletonList(object) : object;
        }
        if (content instanceof Collection) {
            Collection results = ((Collection)content).stream().filter(o -> o instanceof LegacyConfiguredObject).map(LegacyConfiguredObject.class::cast).map(o -> this.convertObject((LegacyConfiguredObject)o, depth, actuals, oversizeThreshold, isSecureOrAllowedOnInsecureChannel, excludeInheritedContext)).collect(Collectors.toSet());
            if (!results.isEmpty()) {
                return results;
            }
        }
        return content;
    }

    protected Map<String, Object> convertObject(LegacyConfiguredObject legacyConfiguredObjectObject, int depth, boolean actuals, int oversizeThreshold, boolean isSecureOrConfidentialOperationAllowedOnInsecureChannel, boolean excludeInheritedContext) {
        return this.getLegacyConfiguredObjectToMapConverter().convertManageableToMap(legacyConfiguredObjectObject, depth, actuals, oversizeThreshold, excludeInheritedContext);
    }
}

