/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.SequenceNumber;
import org.apache.qpid.server.protocol.v1_0.SessionState;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.End;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.protocol.v1_0.type.transport.SenderSettleMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLinkEndpoint<S extends BaseSource, T extends BaseTarget>
implements LinkEndpoint<S, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLinkEndpoint.class);
    private static final int FRAME_HEADER_SIZE = 8;
    private final Link_1_0<S, T> _link;
    private final Session_1_0 _session;
    private volatile SenderSettleMode _sendingSettlementMode;
    private volatile ReceiverSettleMode _receivingSettlementMode;
    private volatile UnsignedInteger _lastSentCreditLimit;
    private volatile boolean _stopped;
    private volatile boolean _stoppedUpdated;
    private volatile Symbol[] _capabilities;
    private volatile SequenceNumber _deliveryCount;
    private volatile UnsignedInteger _linkCredit;
    private volatile UnsignedInteger _available;
    private volatile Boolean _drain;
    private volatile UnsignedInteger _localHandle;
    private volatile Map<Symbol, Object> _properties;
    private volatile State _state = State.ATTACH_RECVD;
    private volatile boolean _errored = false;
    protected boolean _remoteIncompleteUnsettled;
    protected boolean _localIncompleteUnsettled;

    AbstractLinkEndpoint(Session_1_0 session, Link_1_0<S, T> link) {
        this._session = session;
        this._link = link;
    }

    protected abstract void handleDeliveryState(Binary var1, DeliveryState var2, Boolean var3);

    protected abstract void remoteDetachedPerformDetach(Detach var1);

    protected abstract Map<Symbol, Object> initProperties(Attach var1);

    protected abstract Map<Binary, DeliveryState> getLocalUnsettled();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void receiveAttach(Attach attach) throws AmqpErrorException {
        boolean isLocalTerminusNull;
        boolean isAttachingLocalTerminusNull;
        boolean isAttachingRemoteTerminusNull;
        this._errored = false;
        boolean bl = attach.getRole() == Role.SENDER ? attach.getSource() == null : (isAttachingRemoteTerminusNull = attach.getTarget() == null);
        boolean bl2 = attach.getRole() == Role.SENDER ? attach.getTarget() == null : (isAttachingLocalTerminusNull = attach.getSource() == null);
        boolean bl3 = attach.getRole() == Role.SENDER ? this.getTarget() == null : (isLocalTerminusNull = this.getSource() == null);
        if (isAttachingRemoteTerminusNull) {
            throw new AmqpErrorException(AmqpError.INVALID_FIELD, "received Attach with remote null terminus.", new Object[0]);
        }
        if (isAttachingLocalTerminusNull) {
            this.recoverLink(attach);
            return;
        } else if (isLocalTerminusNull) {
            this.establishLink(attach);
            return;
        } else if (attach.getUnsettled() != null) {
            if (!attach.getUnsettled().isEmpty()) throw new AmqpErrorException(new Error(AmqpError.NOT_IMPLEMENTED, "Resuming link is not implemented."));
            this.resumeLink(attach);
            return;
        } else {
            this.reattachLink(attach);
        }
    }

    protected abstract void reattachLink(Attach var1) throws AmqpErrorException;

    protected abstract void resumeLink(Attach var1) throws AmqpErrorException;

    protected abstract void establishLink(Attach var1) throws AmqpErrorException;

    protected abstract void recoverLink(Attach var1) throws AmqpErrorException;

    public void attachReceived(Attach attach) throws AmqpErrorException {
        this._sendingSettlementMode = attach.getSndSettleMode();
        this._receivingSettlementMode = attach.getRcvSettleMode();
        this._properties = this.initProperties(attach);
        this._state = State.ATTACH_RECVD;
        this._remoteIncompleteUnsettled = Boolean.TRUE.equals(attach.getIncompleteUnsettled());
        if (this.getRole() == Role.RECEIVER) {
            this.getSession().getIncomingDeliveryRegistry().removeDeliveriesForLinkEndpoint(this);
        } else {
            this.getSession().getOutgoingDeliveryRegistry().removeDeliveriesForLinkEndpoint(this);
        }
    }

    public boolean isStopped() {
        return this._stopped;
    }

    @Override
    public void setStopped(boolean stopped) {
        if (this._stopped != stopped) {
            this._stopped = stopped;
            this._stoppedUpdated = true;
            this.sendFlowConditional();
        }
    }

    public String getLinkName() {
        return this._link.getName();
    }

    @Override
    public S getSource() {
        return this._link.getSource();
    }

    @Override
    public T getTarget() {
        return this._link.getTarget();
    }

    public NamedAddressSpace getAddressSpace() {
        return this.getSession().getConnection().getAddressSpace();
    }

    protected void setDeliveryCount(SequenceNumber deliveryCount) {
        this._deliveryCount = deliveryCount;
    }

    public void setLinkCredit(UnsignedInteger linkCredit) {
        this._linkCredit = linkCredit;
    }

    public void setAvailable(UnsignedInteger available) {
        this._available = available;
    }

    public void setDrain(Boolean drain) {
        this._drain = drain;
    }

    protected SequenceNumber getDeliveryCount() {
        return this._deliveryCount;
    }

    public UnsignedInteger getAvailable() {
        return this._available;
    }

    public Boolean getDrain() {
        return this._drain;
    }

    public UnsignedInteger getLinkCredit() {
        return this._linkCredit;
    }

    @Override
    public void remoteDetached(Detach detach) {
        switch (this._state) {
            case DETACH_SENT: {
                this._state = State.DETACHED;
                break;
            }
            case ATTACHED: {
                this._state = State.DETACH_RECVD;
                this.remoteDetachedPerformDetach(detach);
            }
        }
    }

    @Override
    public void receiveDeliveryState(Binary deliveryTag, DeliveryState state, Boolean settled) {
        this.handleDeliveryState(deliveryTag, state, settled);
        if (Boolean.TRUE.equals(settled)) {
            this.settle(deliveryTag);
        }
    }

    public void settle(Binary deliveryTag) {
    }

    @Override
    public void setLocalHandle(UnsignedInteger localHandle) {
        this._localHandle = localHandle;
    }

    boolean isAttached() {
        return this._state == State.ATTACHED;
    }

    boolean isDetached() {
        return this._state == State.DETACHED || this._session.isEnded();
    }

    @Override
    public Session_1_0 getSession() {
        return this._session;
    }

    @Override
    public void destroy() {
        this.setLocalHandle(null);
        this.getLink().discardEndpoint();
    }

    @Override
    public UnsignedInteger getLocalHandle() {
        return this._localHandle;
    }

    @Override
    public void sendAttach() {
        Attach attachToSend = new Attach();
        attachToSend.setName(this.getLinkName());
        attachToSend.setRole(this.getRole());
        attachToSend.setHandle(this.getLocalHandle());
        attachToSend.setSource((BaseSource)this.getSource());
        attachToSend.setTarget((BaseTarget)this.getTarget());
        attachToSend.setSndSettleMode(this.getSendingSettlementMode());
        attachToSend.setRcvSettleMode(this.getReceivingSettlementMode());
        attachToSend.setUnsettled(this.getLocalUnsettled());
        attachToSend.setProperties(this._properties);
        attachToSend.setOfferedCapabilities(this._capabilities);
        if (this.getRole() == Role.SENDER) {
            attachToSend.setInitialDeliveryCount(this._deliveryCount.unsignedIntegerValue());
        } else {
            long maxMessageSize = this.getSession().getConnection().getMaxMessageSize();
            if (maxMessageSize != Long.MAX_VALUE) {
                attachToSend.setMaxMessageSize(UnsignedLong.valueOf(maxMessageSize));
            }
        }
        attachToSend = this.handleOversizedUnsettledMapIfNecessary(attachToSend);
        switch (this._state) {
            case DETACHED: {
                this._state = State.ATTACH_SENT;
                break;
            }
            case ATTACH_RECVD: {
                this._state = State.ATTACHED;
                break;
            }
            default: {
                throw new UnsupportedOperationException(this._state.toString());
            }
        }
        this.getSession().sendAttach(attachToSend);
    }

    private Attach handleOversizedUnsettledMapIfNecessary(Attach attachToSend) {
        AMQPDescribedTypeRegistry describedTypeRegistry = this.getSession().getConnection().getDescribedTypeRegistry();
        ValueWriter<Attach> valueWriter = describedTypeRegistry.getValueWriter(attachToSend);
        if (valueWriter.getEncodedSize() + 8 > this.getSession().getConnection().getMaxFrameSize()) {
            int oldIndex;
            this._localIncompleteUnsettled = true;
            attachToSend.setIncompleteUnsettled(true);
            int targetSize = this.getSession().getConnection().getMaxFrameSize();
            int lowIndex = 0;
            Map<Binary, DeliveryState> localUnsettledMap = attachToSend.getUnsettled();
            if (localUnsettledMap == null) {
                localUnsettledMap = Collections.emptyMap();
            }
            int highIndex = localUnsettledMap.size();
            int currentIndex = (highIndex - lowIndex) / 2;
            HashMap<Binary, DeliveryState> unsettledMap = null;
            do {
                HashMap<Binary, DeliveryState> partialUnsettledMap = new HashMap<Binary, DeliveryState>(currentIndex);
                Iterator<Map.Entry<Binary, DeliveryState>> iterator = localUnsettledMap.entrySet().iterator();
                for (int i = 0; i < currentIndex; ++i) {
                    Map.Entry<Binary, DeliveryState> entry = iterator.next();
                    partialUnsettledMap.put(entry.getKey(), entry.getValue());
                }
                attachToSend.setUnsettled(partialUnsettledMap);
                int totalSize = describedTypeRegistry.getValueWriter(attachToSend).getEncodedSize() + 8;
                if (totalSize > targetSize) {
                    highIndex = currentIndex;
                    continue;
                }
                if (totalSize < targetSize) {
                    lowIndex = currentIndex;
                    unsettledMap = partialUnsettledMap;
                    continue;
                }
                lowIndex = highIndex = currentIndex;
                unsettledMap = partialUnsettledMap;
            } while ((oldIndex = currentIndex) != (currentIndex = lowIndex + (highIndex - lowIndex) / 2));
            if (unsettledMap == null || unsettledMap.isEmpty()) {
                End endWithError = new End();
                endWithError.setError(new Error(AmqpError.FRAME_SIZE_TOO_SMALL, "Cannot fit a single unsettled delivery into Attach frame."));
                this.getSession().end(endWithError);
            }
            attachToSend.setUnsettled(unsettledMap);
        } else {
            this._localIncompleteUnsettled = false;
        }
        return attachToSend;
    }

    public void detach() {
        this.detach(null, false);
    }

    public void close() {
        this.detach(null, true);
    }

    public void detach(Error error) {
        this.detach(error, false);
    }

    @Override
    public void close(Error error) {
        this.detach(error, true);
    }

    protected void detach(Error error, boolean close) {
        if (error != null && !this.getSession().isSyntheticError(error)) {
            this._errored = true;
        }
        switch (this._state) {
            case ATTACHED: {
                this._state = State.DETACH_SENT;
                break;
            }
            case DETACH_RECVD: {
                this._state = State.DETACHED;
                break;
            }
            default: {
                if (close) {
                    this.getSession().dissociateEndpoint(this);
                    this.destroy();
                    this._link.linkClosed();
                }
                return;
            }
        }
        if (this.getSession().getSessionState() != SessionState.END_RECVD && !this.getSession().isEnded()) {
            Detach detach = new Detach();
            detach.setHandle(this.getLocalHandle());
            if (close) {
                detach.setClosed(close);
            }
            detach.setError(error);
            this.getSession().sendDetach(detach);
        }
        if (close) {
            this.destroy();
            this._link.linkClosed();
        }
        this.setLocalHandle(null);
    }

    public void sendFlowConditional() {
        if (this._lastSentCreditLimit != null) {
            if (this._stoppedUpdated) {
                this.sendFlow(false);
                this._stoppedUpdated = false;
            } else {
                boolean sendFlow;
                UnsignedInteger clientsCredit = this._lastSentCreditLimit.subtract(this._deliveryCount.unsignedIntegerValue());
                boolean bl = sendFlow = this._linkCredit.subtract(clientsCredit).compareTo(clientsCredit) >= 0;
                if (sendFlow) {
                    this.sendFlow(false);
                } else {
                    this.getSession().sendFlowConditional();
                }
            }
        } else {
            this.sendFlow(false);
        }
    }

    @Override
    public void sendFlow() {
        this.sendFlow(false);
    }

    private void sendFlow(boolean echo) {
        if (this._state == State.ATTACHED || this._state == State.ATTACH_SENT) {
            Flow flow = new Flow();
            flow.setDeliveryCount(this._deliveryCount.unsignedIntegerValue());
            flow.setEcho(echo);
            if (this._stopped) {
                flow.setLinkCredit(UnsignedInteger.ZERO);
                flow.setDrain(true);
                this._lastSentCreditLimit = this._deliveryCount.unsignedIntegerValue();
            } else {
                flow.setLinkCredit(this._linkCredit);
                this._lastSentCreditLimit = this._linkCredit.add(this._deliveryCount.unsignedIntegerValue());
                flow.setDrain(this._drain);
            }
            flow.setAvailable(this._available);
            flow.setHandle(this.getLocalHandle());
            this.getSession().sendFlow(flow);
        }
    }

    protected Link_1_0<S, T> getLink() {
        return this._link;
    }

    @Override
    public SenderSettleMode getSendingSettlementMode() {
        return this._sendingSettlementMode;
    }

    @Override
    public ReceiverSettleMode getReceivingSettlementMode() {
        return this._receivingSettlementMode;
    }

    public List<Symbol> getCapabilities() {
        return this._capabilities == null ? null : Collections.unmodifiableList(Arrays.asList(this._capabilities));
    }

    public void setCapabilities(Collection<Symbol> capabilities) {
        this._capabilities = capabilities == null ? null : capabilities.toArray(new Symbol[capabilities.size()]);
    }

    public boolean isErrored() {
        return this._errored;
    }

    public String toString() {
        return "LinkEndpoint{_name='" + this.getLinkName() + "', _session=" + String.valueOf((Object)this._session) + ", _state=" + String.valueOf((Object)this._state) + ", _role=" + String.valueOf(this.getRole()) + ", _source=" + String.valueOf(this.getSource()) + ", _target=" + String.valueOf(this.getTarget()) + ", _transferCount=" + String.valueOf(this._deliveryCount) + ", _linkCredit=" + String.valueOf(this._linkCredit) + ", _available=" + String.valueOf(this._available) + ", _drain=" + this._drain + ", _localHandle=" + String.valueOf(this._localHandle) + "}";
    }

    protected static enum State {
        DETACHED,
        ATTACH_SENT,
        ATTACH_RECVD,
        ATTACHED,
        DETACH_SENT,
        DETACH_RECVD;

    }
}

