/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceInstanceCache {
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceInstanceCache.class);
    private static final Cache<String, MicroserviceInstance> instances = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static final Cache<String, Microservice> microservices = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();

    public static Microservice getOrCreate(String serviceId) {
        try {
            return (Microservice)microservices.get((Object)serviceId, () -> {
                Microservice microservice = DiscoveryManager.INSTANCE.getMicroservice(serviceId);
                if (microservice == null) {
                    throw new IllegalArgumentException("service id not exists.");
                }
                return microservice;
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.error("get microservice from cache failed, {}, {}", (Object)serviceId, (Object)e.getMessage());
            return null;
        }
    }

    public static MicroserviceInstance getOrCreate(String serviceId, String instanceId) {
        try {
            String key = String.format("%s@%s", serviceId, instanceId);
            return (MicroserviceInstance)instances.get((Object)key, () -> {
                MicroserviceInstance instance = DiscoveryManager.INSTANCE.getMicroserviceInstance(serviceId, instanceId);
                if (instance == null) {
                    throw new IllegalArgumentException("instance id not exists.");
                }
                return instance;
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.error("get microservice instance from cache failed, {}, {}", (Object)String.format("%s@%s", serviceId, instanceId), (Object)e.getMessage());
            return null;
        }
    }
}

