/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation.endpoint;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.invocation.endpoint.EndpointUtils;

public final class EndpointCacheUtils {
    private static final LoadingCache<String, Endpoint> CACHE = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Endpoint>(){

        public Endpoint load(String uri) {
            return EndpointCacheUtils.create(uri);
        }
    });

    public static Endpoint getOrCreate(String uri) {
        return (Endpoint)CACHE.getUnchecked((Object)uri);
    }

    public static Endpoint create(String uri) {
        return EndpointUtils.parse(EndpointUtils.formatFromUri(uri));
    }
}

