/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import net.sf.oval.AbstractCheck;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.configuration.annotation.AnnotationCheck;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ReflectionUtils;

public abstract class AbstractAnnotationCheck<ConstraintAnnotation extends Annotation>
extends AbstractCheck
implements AnnotationCheck<ConstraintAnnotation> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(AbstractAnnotationCheck.class);

    @Override
    public void configure(ConstraintAnnotation constraintAnnotation) {
        Class<?> constraintClazz = constraintAnnotation.getClass();
        Method getMessage = ReflectionUtils.getMethod(constraintClazz, "message", null);
        if (getMessage == null) {
            LOG.debug("Cannot determine constraint error message based on annotation {1} since attribtue message() is not defined.", constraintClazz.getName());
        } else {
            try {
                this.setMessage((String)getMessage.invoke(constraintAnnotation, null));
            }
            catch (Exception ex) {
                LOG.warn("Cannot determine constraint error message based on annotation {1}", (Object)constraintClazz.getName(), ex);
                try {
                    this.setMessage(String.valueOf(constraintClazz.getName()) + ".violated");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        Method getAppliesTo = ReflectionUtils.getMethod(constraintClazz, "appliesTo", null);
        if (getAppliesTo == null) {
            LOG.debug("Cannot determine constraint targets based on annotation {1} since attribtue appliesTo() is not defined.", constraintClazz.getName());
        } else {
            try {
                this.setAppliesTo((ConstraintTarget[])getAppliesTo.invoke(constraintAnnotation, null));
            }
            catch (Exception ex) {
                LOG.warn("Cannot determine constraint targets based on annotation {1}", (Object)constraintClazz.getName(), ex);
            }
        }
        Method getErrorCode = ReflectionUtils.getMethod(constraintClazz, "errorCode", null);
        if (getErrorCode == null) {
            LOG.debug("Cannot determine constraint error code based on annotation {1} since attribtue errorCode() is not defined.", constraintClazz.getName());
        } else {
            try {
                this.setErrorCode((String)getErrorCode.invoke(constraintAnnotation, null));
            }
            catch (Exception ex) {
                LOG.warn("Cannot determine constraint error code based on annotation {1}", (Object)constraintClazz.getName(), ex);
                try {
                    this.setErrorCode(constraintClazz.getName());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        Method getSeverity = ReflectionUtils.getMethod(constraintClazz, "severity", null);
        if (getSeverity == null) {
            LOG.debug("Cannot determine constraint severity based on annotation {1} since attribtue severity() is not defined.", constraintClazz.getName());
        } else {
            try {
                this.setSeverity(((Number)getSeverity.invoke(constraintAnnotation, null)).intValue());
            }
            catch (Exception ex) {
                LOG.warn("Cannot determine constraint severity based on annotation {1}", (Object)constraintClazz.getName(), ex);
            }
        }
        Method getProfiles = ReflectionUtils.getMethod(constraintClazz, "profiles", null);
        if (getProfiles == null) {
            LOG.debug("Cannot determine constraint profiles based on annotation {1} since attribtue profiles() is not defined.", constraintClazz.getName());
        } else {
            try {
                this.setProfiles((String[])getProfiles.invoke(constraintAnnotation, null));
            }
            catch (Exception ex) {
                LOG.warn("Cannot determine constraint profiles based on annotation {1}", (Object)constraintClazz.getName(), ex);
            }
        }
        Method getTarget = ReflectionUtils.getMethod(constraintClazz, "target", null);
        if (getTarget == null) {
            LOG.debug("Cannot determine constraint target based on annotation {1} since attribtue target() is not defined.", constraintClazz.getName());
        } else {
            try {
                this.setTarget((String)getTarget.invoke(constraintAnnotation, null));
            }
            catch (Exception ex) {
                LOG.warn("Cannot determine constraint target based on annotation {1}", (Object)constraintClazz.getName(), ex);
            }
        }
        Method getWhen = ReflectionUtils.getMethod(constraintClazz, "when", null);
        if (getWhen == null) {
            LOG.debug("Cannot determine constraint when formula based on annotation {1} since attribtue when() is not defined.", constraintClazz.getName());
        } else {
            try {
                this.setWhen((String)getWhen.invoke(constraintAnnotation, null));
            }
            catch (Exception ex) {
                LOG.warn("Cannot determine constraint when formula based on annotation {1}", (Object)constraintClazz.getName(), ex);
            }
        }
    }
}

