/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.MSBRadixSorter;
import org.apache.lucene.util.Sorter;

public abstract class StableMSBRadixSorter
extends MSBRadixSorter {
    private final int[] fixedStartOffsets = new int[257];

    public StableMSBRadixSorter(int maxLength) {
        super(maxLength);
    }

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    @Override
    protected Sorter getFallbackSorter(final int k) {
        return new MergeSorter(){

            @Override
            protected void save(int i, int j) {
                StableMSBRadixSorter.this.save(i, j);
            }

            @Override
            protected void restore(int i, int j) {
                StableMSBRadixSorter.this.restore(i, j);
            }

            @Override
            protected void swap(int i, int j) {
                StableMSBRadixSorter.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                for (int o = k; o < StableMSBRadixSorter.this.maxLength; ++o) {
                    int b2;
                    int b1 = StableMSBRadixSorter.this.byteAt(i, o);
                    if (b1 != (b2 = StableMSBRadixSorter.this.byteAt(j, o))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }
        };
    }

    @Override
    protected void reorder(int from, int to, int[] startOffsets, int[] endOffsets, int k) {
        System.arraycopy(startOffsets, 0, this.fixedStartOffsets, 0, startOffsets.length);
        for (int i = 0; i < 257; ++i) {
            int limit = endOffsets[i];
            for (int h1 = this.fixedStartOffsets[i]; h1 < limit; ++h1) {
                int h2;
                int b;
                int n = b = this.getBucket(from + h1, k);
                startOffsets[n] = startOffsets[n] + 1;
                this.save(from + h1, from + h2);
            }
        }
        this.restore(from, to);
    }

    protected static abstract class MergeSorter
    extends Sorter {
        protected MergeSorter() {
        }

        @Override
        public void sort(int from, int to) {
            this.checkRange(from, to);
            this.mergeSort(from, to);
        }

        private void mergeSort(int from, int to) {
            if (to - from < 20) {
                this.binarySort(from, to);
            } else {
                int mid = from + to >>> 1;
                this.mergeSort(from, mid);
                this.mergeSort(mid, to);
                this.merge(from, to, mid);
            }
        }

        protected abstract void save(int var1, int var2);

        protected abstract void restore(int var1, int var2);

        private void bulkSave(int from, int tmpFrom, int len) {
            for (int i = 0; i < len; ++i) {
                this.save(from + i, tmpFrom + i);
            }
        }

        private void merge(int from, int to, int mid) {
            block6: {
                assert (to > mid && mid > from);
                if (this.compare(mid - 1, mid) <= 0) {
                    return;
                }
                int left = from;
                int right = mid;
                int index = from;
                while (true) {
                    int cmp;
                    if ((cmp = this.compare(left, right)) <= 0) {
                        this.save(left++, index++);
                        if (left != mid) continue;
                        assert (index == right);
                        this.bulkSave(right, index, to - right);
                        break block6;
                    }
                    this.save(right++, index++);
                    if (right == to) break;
                }
                assert (to - index == mid - left);
                this.bulkSave(left, index, mid - left);
            }
            this.restore(from, to);
        }
    }
}

