/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.tika.batch.IFileProcessorFutureResult;
import org.apache.tika.batch.InterrupterFutureResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interrupter
implements Callable<IFileProcessorFutureResult> {
    private static final Logger LOG = LoggerFactory.getLogger(Interrupter.class);
    private static final long EXTRA_GRACE_PERIOD_MILLIS = 1000L;
    private final long pauseOnEarlyTermination;

    public Interrupter(long pauseOnEarlyTermination) {
        this.pauseOnEarlyTermination = pauseOnEarlyTermination;
    }

    @Override
    public IFileProcessorFutureResult call() {
        try {
            InputStream is = System.in;
            int byt = is.read();
            while (byt > -1) {
                byt = is.read();
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception from STDIN in CommandlineInterrupter.", e);
        }
        new Thread(new Doomsday()).start();
        return new InterrupterFutureResult();
    }

    private class Doomsday
    implements Runnable {
        private Doomsday() {
        }

        @Override
        public void run() {
            if (Interrupter.this.pauseOnEarlyTermination < 0L) {
                return;
            }
            long start = System.currentTimeMillis();
            long elapsed = System.currentTimeMillis() - start;
            while (elapsed < Interrupter.this.pauseOnEarlyTermination + 1000L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
                elapsed = System.currentTimeMillis() - start;
            }
            LOG.error("Interrupter timed out; now calling System.exit.");
            System.exit(-1);
        }
    }
}

