/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.reports;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.tika.eval.app.reports.XSLXCellFormatter;

class XLSXNumFormatter
implements XSLXCellFormatter {
    private final String formatString;
    private CellStyle style;

    XLSXNumFormatter(String formatString) {
        this.formatString = formatString;
    }

    @Override
    public void reset(XSSFWorkbook workbook) {
        this.style = workbook.createCellStyle();
        this.style.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat(this.formatString));
    }

    @Override
    public void applyStyleAndValue(int dbColNum, ResultSet resultSet, Cell cell) throws SQLException {
        double d = resultSet.getDouble(dbColNum);
        if (!resultSet.wasNull()) {
            cell.setCellStyle(this.style);
        }
        cell.setCellValue(resultSet.getDouble(dbColNum));
    }
}

