/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.convert;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.commons.Internal;
import opennlp.tools.parser.Parse;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

@Internal
public class ParseToPOSSampleStream
extends FilterObjectStream<Parse, POSSample> {
    public ParseToPOSSampleStream(ObjectStream<Parse> samples) {
        super(samples);
    }

    @Override
    public POSSample read() throws IOException {
        Parse parse = (Parse)this.samples.read();
        if (parse != null) {
            ArrayList<String> sentence = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            for (Parse tagNode : parse.getTagNodes()) {
                sentence.add(tagNode.getCoveredText());
                tags.add(tagNode.getType());
            }
            return new POSSample(sentence, tags);
        }
        return null;
    }
}

