/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.impl.AbstractResponseContextImpl;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;

public class ClientResponseContextImpl
extends AbstractResponseContextImpl
implements ClientResponseContext {
    public ClientResponseContextImpl(ResponseImpl r, Message m) {
        super(r, m);
    }

    @Override
    public InputStream getEntityStream() {
        InputStream is = this.m.getContent(InputStream.class);
        if (is == null) {
            is = this.r.convertEntityToStreamIfPossible();
        }
        return is;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return HttpUtils.getModifiableStringHeaders(this.m);
    }

    @Override
    public void setEntityStream(InputStream is) {
        this.m.setContent(InputStream.class, is);
        this.r.setEntity(is, this.r.getEntityAnnotations());
    }

    @Override
    public boolean hasEntity() {
        if (HttpUtils.isPayloadEmpty(this.getHeaders())) {
            return false;
        }
        try {
            return !IOUtils.isEmpty(this.getEntityStream());
        }
        catch (IOException ex) {
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }
}

