/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.BufferedGridCoverage;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.coverage.grid.j2d.ColorModelBuilder;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.grid.j2d.ObservableImage;
import org.apache.sis.coverage.grid.j2d.TiledImage;
import org.apache.sis.coverage.grid.j2d.WritableTiledImage;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.TransformException;

public class GridCoverageBuilder {
    private GridGeometry domain;
    private List<SampleDimension> ranges;
    private int visibleBand;
    private RenderedImage image;
    private Raster raster;
    private DataBuffer buffer;
    private Dimension size;
    private long flippedAxes;
    private final Hashtable<String, Object> properties = new Hashtable();

    public GridCoverageBuilder setDomain(GridGeometry grid) {
        this.domain = grid != GridGeometry.UNDEFINED ? grid : null;
        return this;
    }

    public GridCoverageBuilder setDomain(Envelope domain) {
        return this.setDomain(domain == null ? null : new GridGeometry(domain));
    }

    public GridCoverageBuilder setRanges(Collection<? extends SampleDimension> bands) {
        if (bands == null) {
            this.ranges = null;
        } else {
            ArgumentChecks.ensureNonEmpty("bands", bands);
            if (this.ranges instanceof ArrayList) {
                this.ranges.clear();
                this.ranges.addAll(bands);
            } else {
                this.ranges = new ArrayList<SampleDimension>(bands);
            }
        }
        return this;
    }

    public GridCoverageBuilder setRanges(SampleDimension ... bands) {
        if (bands == null) {
            this.ranges = null;
        } else {
            ArgumentChecks.ensureNonEmpty("bands", bands);
            this.ranges = Arrays.asList(bands);
        }
        return this;
    }

    public GridCoverageBuilder addRange(SampleDimension band) {
        ArgumentChecks.ensureNonNull("band", band);
        if (!(this.ranges instanceof ArrayList)) {
            this.ranges = this.ranges != null ? new ArrayList<SampleDimension>(this.ranges) : new ArrayList();
        }
        this.ranges.add(band);
        return this;
    }

    public GridCoverageBuilder setValues(RenderedImage data) {
        ArgumentChecks.ensureNonNull("data", data);
        this.image = data;
        this.raster = null;
        this.buffer = null;
        this.size = null;
        return this;
    }

    public GridCoverageBuilder setValues(Raster data) {
        ArgumentChecks.ensureNonNull("data", data);
        this.raster = data;
        this.image = null;
        this.buffer = null;
        this.size = null;
        return this;
    }

    public GridCoverageBuilder setValues(DataBuffer data, Dimension size) {
        ArgumentChecks.ensureNonNull("data", data);
        if (size != null) {
            size = new Dimension(size);
            ArgumentChecks.ensureStrictlyPositive("width", size.width);
            ArgumentChecks.ensureStrictlyPositive("height", size.height);
            int length = Math.multiplyExact(size.width, size.height);
            int capacity = data.getSize();
            if (length > capacity) {
                throw new IllegalArgumentException(Errors.format((short)133, length, capacity));
            }
        }
        this.size = size;
        this.buffer = data;
        this.image = null;
        this.raster = null;
        return this;
    }

    public GridCoverageBuilder flipGridAxis(int dimension) {
        ArgumentChecks.ensurePositive("dimension", dimension);
        if (dimension >= 64) {
            throw new ArithmeticException(Errors.format((short)37, dimension + 1));
        }
        this.flippedAxes ^= 1L << dimension;
        return this;
    }

    public GridCoverageBuilder addImageProperty(String key, Object value) {
        ArgumentChecks.ensureNonNull("key", key);
        ArgumentChecks.ensureNonNull("value", value);
        if (this.properties.putIfAbsent(key, value) != null) {
            throw new IllegalArgumentException(Errors.format((short)27, key));
        }
        return this;
    }

    public GridCoverage build() throws IllegalStateException {
        GridGeometry grid = this.domain;
        List<SampleDimension> bands = this.ranges;
        try {
            if (this.image == null) {
                if (this.raster == null) {
                    if (this.buffer == null) {
                        throw new IllegalStateException(GridCoverageBuilder.missingProperty("values"));
                    }
                    if (this.size != null) {
                        grid = GridCoverage2D.addExtentIfAbsent(grid, new Rectangle(this.size));
                        GridCoverageBuilder.verifyGridExtent(grid.getExtent(), this.size.width, this.size.height);
                    } else if (grid == null) {
                        throw new IncompleteGridGeometryException(GridCoverageBuilder.missingProperty("size"));
                    }
                    bands = GridCoverage2D.defaultIfAbsent(bands, null, this.buffer.getNumBanks());
                    return new BufferedGridCoverage(this.domainWithAxisFlips(grid), bands, this.buffer);
                }
                bands = GridCoverage2D.defaultIfAbsent(bands, null, this.raster.getNumBands());
                ColorModelBuilder colorizer = new ColorModelBuilder(ColorModelBuilder.GRAYSCALE, null, false);
                SampleModel sm = this.raster.getSampleModel();
                ColorModel colors = colorizer.initialize(sm, bands.get(this.visibleBand)) || colorizer.initialize(sm, this.visibleBand) ? colorizer.createColorModel(ImageUtilities.getBandType(sm), bands.size(), this.visibleBand) : ColorModelBuilder.NULL_COLOR_MODEL;
                if (bands != null) {
                    this.properties.put("org.apache.sis.SampleDimensions", bands.toArray(SampleDimension[]::new));
                } else {
                    this.properties.remove("org.apache.sis.SampleDimensions");
                }
                if (this.raster instanceof WritableRaster) {
                    WritableRaster wr = (WritableRaster)this.raster;
                    this.image = colors != null && (wr.getMinX() | wr.getMinY()) == 0 ? new ObservableImage(colors, wr, false, this.properties) : new WritableTiledImage((Map<String, Object>)this.properties, colors, wr.getWidth(), wr.getHeight(), 0, 0, wr);
                } else {
                    this.image = new TiledImage(this.properties, colors, this.raster.getWidth(), this.raster.getHeight(), 0, 0, this.raster);
                }
                this.properties.remove("org.apache.sis.SampleDimensions");
            }
            return new GridCoverage2D(this.domainWithAxisFlips(grid), bands, this.image);
        }
        catch (ArithmeticException | IllegalArgumentException | NullPointerException | TransformException e) {
            throw new IllegalStateException(Resources.format((short)3), e);
        }
    }

    private GridGeometry domainWithAxisFlips(GridGeometry grid) throws TransformException {
        long f = this.flippedAxes;
        if (f != 0L && (grid = GridCoverage2D.addExtentIfAbsent(grid, this.image)) != null && grid.isDefined(4)) {
            int j;
            GridExtent extent = grid.getExtent();
            int srcDim = extent.getDimension();
            MatrixSIS flip = Matrices.createDiagonal(grid.getTargetDimension() + 1, srcDim + 1);
            do {
                j = Long.numberOfTrailingZeros(f);
                flip.setElement(j, j, -1.0);
                flip.setElement(j, srcDim, extent.getSize(j, false));
            } while ((f &= 1L << j ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            grid = new GridGeometry(grid, extent, MathTransforms.linear(flip));
        }
        return grid;
    }

    private static void verifyGridExtent(GridExtent extent, int ... expectedSize) {
        int[] imageAxes = extent.getSubspaceDimensions(expectedSize.length);
        for (int i = 0; i < expectedSize.length; ++i) {
            int imageSize = expectedSize[i];
            long gridSize = extent.getSize(imageAxes[i]);
            if ((long)imageSize == gridSize) continue;
            throw new IllegalGridGeometryException(Resources.format((short)44, i, imageSize, gridSize));
        }
    }

    private static String missingProperty(String name) {
        return Errors.format((short)89, name);
    }
}

