/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.sis.feature.DefaultFeatureType;

final class CommonParentFinder {
    private final Map<DefaultFeatureType, Boolean> allTypes;
    private final DefaultFeatureType[] required;
    private final int count;

    static DefaultFeatureType select(Iterable<? extends DefaultFeatureType> types) {
        LinkedHashMap<DefaultFeatureType, Boolean> allTypes = new LinkedHashMap<DefaultFeatureType, Boolean>();
        types.forEach(type -> allTypes.putIfAbsent((DefaultFeatureType)type, Boolean.FALSE));
        allTypes.remove(null);
        int count = allTypes.size();
        DefaultFeatureType[] required = allTypes.keySet().toArray(new DefaultFeatureType[count]);
        for (int i = 0; i < count; ++i) {
            DefaultFeatureType parent = required[i];
            int j = count;
            while (--j >= 0) {
                if (j == i || !parent.isAssignableFrom(required[j])) continue;
                System.arraycopy(required, j + 1, required, j, --count - j);
                required[count] = null;
                if (j >= i) continue;
                --i;
            }
        }
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                return required[0];
            }
        }
        return new CommonParentFinder(allTypes, required, count).select();
    }

    private CommonParentFinder(Map<DefaultFeatureType, Boolean> allTypes, DefaultFeatureType[] required, int count) {
        this.allTypes = allTypes;
        this.required = required;
        this.count = count;
        for (int i = 0; i < count; ++i) {
            this.scanParents(required[i]);
        }
    }

    private boolean isAssignableFromAll(DefaultFeatureType parent) {
        for (int i = 0; i < this.count; ++i) {
            DefaultFeatureType type = this.required[i];
            if (type == parent || parent.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    private void scanParents(DefaultFeatureType type) {
        for (DefaultFeatureType parent : type.getSuperTypes()) {
            if (this.allTypes.putIfAbsent(parent, Boolean.FALSE) != null) continue;
            if (this.isAssignableFromAll(parent)) {
                this.allTypes.put(parent, Boolean.TRUE);
                this.skipParents(parent);
                continue;
            }
            this.scanParents(parent);
        }
    }

    private void skipParents(DefaultFeatureType type) {
        assert (this.isAssignableFromAll(type));
        for (DefaultFeatureType parent : type.getSuperTypes()) {
            if (Boolean.TRUE.equals(this.allTypes.put(parent, Boolean.FALSE))) continue;
            this.skipParents(parent);
        }
    }

    DefaultFeatureType select() {
        this.allTypes.values().removeIf(Predicate.isEqual(Boolean.FALSE));
        DefaultFeatureType best = null;
        int numProperties = 0;
        for (DefaultFeatureType type : this.allTypes.keySet()) {
            int n = type.getProperties(true).size();
            if (best != null && n <= numProperties) continue;
            best = type;
            numProperties = n;
        }
        return best;
    }
}

